
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	
;;;;	Project : some io benchmarks do see where bottleneck is.
;;;;	Do simple byte io with no term parsing to see if still slow.	
;;;;	Rehabilitate bigterm test to check perf on compression.
;;;;	


;;;; -docs- (mod tst)
;;;;	
;;;;	Socket io is done by doing stream io to c-programs which then
;;;;	do socket io. Eventually, I hope to remove the middle man but
;;;;	this is a quick and dirty method fttb.
;;;;	
;;;;	Caveats: 
;;;;	
;;;;	Anytime IO is done on a socket connection a > or < character is
;;;;	printed to console. If this gets annoying I can disable. At the
;;;;	moment, I believe it is useful to see what's happening.
;;;;	
;;;;  -page-
;;;;	
;;;;	IO Trace : Following lisp functions allow tracing of io to other components.
;;;;	
;;;;	(open-io-trace-file <bool{version-p}>)
;;;;	  - opens file in users home directory with a name such as LIB.trace.
;;;;	  - version-p is optional arg. If t then file will be opened with a version number
;;;;	    so as to prevent loss of other trace files. Default is nil.
;;;;	
;;;;	(close-io-trace-file)
;;;;	(flush-io-trace-file)
;;;;	  - in order to insure all trace data is in the file, the file must be
;;;;	    close or flushed before the lisp process is killed.
;;;;	  - the file should be closed before it is rm'ed or mv'ed.
;;;;
;;;; -doce- 


;;;;	
;;;;	Environment : a collection of tables and possibly a source
;;;;	  of broadcasts. Tables are updated by broadcasts. Typically
;;;;	  only library environments produce broadcasts.
;;;;
;;;;	Orb : A psuedo-orb interface is supplied to connect
;;;;	  environments
;;;;	
;;;;	Configuration : the process of establishing and connecting environments.
;;;;
;;;;	Description : attribute of environment used to decide applicability of
;;;; 	  broadcasts for the enviroment. Objects in the library may be tagged
;;;;	  with a description. Broadcasts carry the description of object generating
;;;;	  the broadcast.
;;;; 
;;;;	Environment attributes :
;;;;	  - address : tok list. The address is unique among all possible environment.
;;;;	      * First token is system and version, eg FDL.0.
;;;;	      * Second token is a unique process id. 
;;;;	        currently, universal time at init thus not guaraunteed unique.
;;;;	  - description : system name and version, a list of purposes
;;;;	      * purposes : an indication of the roles the environment will play
;;;;		within the system.
;;;;	  - resources : tables present in the environment.
;;;;	  - produces : table-types of broadcasts produced within the environment.
;;;;	  - reduces : tags used to reduce (expand abstraction) terms prior to evaluation
;;;;	      by the environment.
;;;;	
;;;;	Library Journal : journals may be kept for library environments. 
;;;;	  A journaled library environment is persistent. The journal is 
;;;;	  used to re-establish a previous environment after a close or crash.
;;;;	
;;;;	
;;;;
;;;;	new_environment : tok list -> tok list -> tok list -> tok list -> tok-list -> unit
;;;;	  * tok list : environment address.
;;;;	  * tok list : purposes.
;;;;	  * tok list : resource tags - local resources available (ie receive broadcasts for) .
;;;;	  * tok list : table types - tables produced (ie is server for).
;;;;	  * tok list : reduction tags.
;;;;	** Creates and opens specified environment.
;;;;	** At the moment, all resources must be unique within the environment.
;;;;	   At some point, it may be a useful extension to allow multiple similar
;;;;	   resources within an environment.
;;;;	** purposes : used to route messages. Ie allows discrimination even if
;;;;	    you accept the broadcast type for other purposes. Ie, term broadcasts
;;;;	    may have an ObjectIdDag purpose and if you do not then you would not see them.
;;;;	    does filtering between receiver and object by matching descriptions.
;;;;	EG:
;;;;	new_environment [sys_version(); orb_name(); `library`; `test`]
;;;;	   		``LIBRARY``
;;;;			``LIBRARY ABSTRACTIONS``
;;;;			``LIBRARY LIBRARY-HEAVY LIBRARY-LIGHT ABSTRACTIONS DFORMS
;;;;			  PRECEDENCES STATEMENTS PROOFS RULES``
;;;;			``LIB LIBRARY``;;
;;;;
;;;;	close_environment : tok list -> unit
;;;;	  * tok list : environment address.
;;;;
;;;;	%%clone_environment : tok list -> tok list -> unit
;;;;	  * tok list : environment address of original
;;;;	  * tok list : environment address of clone.
;;;;	** not yet implemented.
;;;;
;;;;
;;;;	env_start_library_journal : tok list -> unit
;;;;	  * tok list : address of library environment to be journaled.
;;;;	
;;;;	env_stop_library_journal : tok list -> unit
;;;;	  * tok list : address of library environment to be journaled.
;;;;	
;;;;	journals_list : tok list -> (tok list list)
;;;;	  * tok list : arg.
;;;;	  * tok list list : addresses of journaled environments in the persistent
;;;;		store which are supersets of the arg tok list.
;;;;
;;;;	journals_pop : unit -> unit
;;;;	  * This is a kludge until more sophisticated journal management tools are avaiable.
;;;;	  * Once the journal is popped it is gone forever.
;;;;	  * Use : assume you open_lib then close. That adds a journal to the stack which
;;;;	    shadows journals with similar name. If you want to remove the most recent journal
;;;;	    so that you may access a shadowed one then journals_pop will do that.
;;;;
;;;;	open_environment : tok list -> unit
;;;;	  * tok list : environment address of environment in persistent store
;;;;		       to be re-established.
;;;;
;;;;	
;;;;	orb_start_accept : int -> unit 
;;;;	  * start accept for connections on specified socket.
;;;;	
;;;;	orb_start_connect : int -> unit 
;;;;	orb_start_disconnect : int -> unit 
;;;;	
;;;;	orb_stop_accept : int -> unit
;;;;	
;;;;	??? what happens to open connects on stop accept???
;;;;
;;;;	Link : the connection made when a connect is accepted.
;;;;
;;;;	Each process will have an orb environment established.
;;;;	The orb environment is used to evaluate configuration
;;;;	requests and to examine orb state. The orb environment
;;;;	is established automatically at initialization.
;;;;	
;;;;	orb_address : unit -> tok list
;;;;	  * local orb address.
;;;;	
;;;;	orb_request_orb_address : int -> tok list
;;;;	  ** request orb environment address of remote orb connected on specified socket.
;;;;
;;;;	orb_send_orb_address : int -> unit
;;;;	  ** sends orb environment address to remote orb.
;;;;
;;;;	



;;;;	
;;;;	Startup : we desire startup to be as simple as possible and
;;;;	 we desire the enviroments to be customizable as possible.
;;;;	
;;;;	Solution is to make configuration programmable at various
;;;;	levels where the highest level is a canned startup.
;;;;	
;;;;	Every lisp interpreter will have a boot orb environment established.
;;;;	The orb environment is used as a default environment for a link.
;;;;	It is used as an environment in which to evaluate link configuration
;;;;	expressions. It is used as an environment in which to evaluate expressions
;;;;	to open other environments.
;;;;	
;;;;	boot orb server environment needs to inform connected of local boot env address
;;;;	at connection time. This allows remote edd client to configure lib server.
;;;;	
;;;;	orb_name : unit -> tok
;;;;	  * a name which must be unique among connected orbs.
;;;;	  * Then the orb boot environment address is [`FDL0`; orb_name; `orb`].
;;;;	
;;;;	
;;;;	Environment : a collection of resources and possibly a producer of
;;;;	  broadcasts. Each environment has a stamp.
;;;;
;;;;	Table : each resource is implemented as a table. 
;;;;	
;;;;	Table types : various views of a table are possible. Each view will be
;;;;	  implemented as a set of table types. 
;;;;
;;;;	Broadcasts : for each table some set of broadcasts are applicable.
;;;;	  In addition to the broadcast id, each broadcast contains a table type
;;;;	  and the environment stamp of the producer environment.
;;;;	
;;;;	RLE TODO : broadcast stamp not necessarily environment stamp at the moment.
;;;;
;;;;	Producer : an environment which emits broadcasts. Production is determined
;;;;	 by evaluable commands in loaded code.
;;;;	Consumer : an environment which applies broadcasts.
;;;;
;;;;	RLE TODO : Could have edd environment in lib
;;;;	RLE TODO : interpreter which produces non-sensical lib bcasts. This will be fixed
;;;;	RLE TODO : by code objects and lifting implementation configuration into library.
;;;;	 
;;;;	All tables are updated by listening for broadcasts for the appropriate
;;;;	table types, even those within the producer's environment. However,
;;;;	a broadcast produced within an environment is not transmitted until
;;;;	the producer environment table is successfully updated. The update
;;;;	of the producer environment by a broadcast may fail. The update
;;;;	to a table not of the producer environment may not fail.
;;;;
;;;;	Note : an alternative would be to require the producer to pre-check
;;;;	  that the broadcast will be successful and fail prior to the broadcast.
;;;;	  In this scenario, it is problemmatical to ensure that the pre-checker
;;;;	  will detect all possible failure modes. Thus it was deemed more robust
;;;;	  to let the broadcast fail in the producer environment. This is not to
;;;;	  say that non-producers must completely accept the broadcast, however
;;;;	  they must accept enough so that their table is not corrupted.
;;;;	RLE ??? : maybe producer is not the correct concept here but instead
;;;;	RLE ??? : some notion of a primary consumer(s) which applies broadcast first
;;;;	RLE ??? : and then must reply with failure or ack. Then we have transactions
;;;;	RLE ??? : waiting on bus traffic. Primary consumers should not be required.
;;;;	RLE ??? : when required they should be local as much as is pratical.
;;;;	RLE ??? : multiple problematical? No. If any failed then all that acked
;;;;	RLE ??? : can be undone.
;;;;
;;;;
;;;;	Resources :	 Table Types :
;;;;	  - LIBRARY	 : LIBRARY, LIBRARY-HEAVY, LIBRARY-LIGHT
;;;;	  - ABSTRACTIONS : ABSTRACTIONS
;;;;	  - DFORMS	 : DFORMS
;;;;	  - PRECEDENCES	 : PRECEDENCES
;;;;	  - STATEMENTS	 : STATEMENTS
;;;;	  - PROOFS	 : PROOFS
;;;;	  - RULES	 : RULES
;;;;
;;;;	  - EDIT-LIBRARY : LIBRARY, LIBRARY-LIGHT
;;;;	
;;;;	  Not currently supported :
;;;;	  - DMS-DFORMS		: DMS-DFORMS
;;;;	  - DMS-PRECEDECENCES	: DMS-PRECEDECENCES
;;;;	
;;;;	
;;;;	RLE TODO : need to allow further discrimination of broadcasts and table types
;;;;	RLE TODO : by appending more tags to broadcast to direct broadcast to appropriate 
;;;;	RLE TODO : consumers. eg, do not want to send all code to all code consumers.
;;;;	RLE TODO : there is refiner specific code and edit specific code and caml code
;;;;	RLE TODO : and sml code and lisp code. Also similar prob for multiple similar tables.
;;;;	RLE TODO : summary: need finer grained matching of broadcasts with tables.
;;;;
;;;;	
;;;;	Configuration Convention :
;;;;	  - Every environment is primarly described by the table types produced and consumed.
;;;;	    Certain configurations of production and consumption have been identified.
;;;;	      * LIB : 
;;;;		Produces : LIBRARY, LIBRARY-HEAVY, LIBRARY-LIGHT, ABSTRACTIONS,
;;;;			   DFORMS, PRECEDENCES, STATEMENTS, PROOFS, RULES, CODE
;;;;		Consumes : LIBRARY, LIBRARY-HEAVY, ABSTRACTIONS, CODE
;;;;	      * EDD : 
;;;;		Produces : NIL
;;;;		Consumes : LIBRARY, LIBRARY-LIGHT, ABSTRACTIONS, DFORMS, PRECEDENCES, CODE
;;;;	      * REF : 
;;;;		Produces : NIL
;;;;		Consumes : ABSTRACTIONS, STATEMENTS, PROOFS, RULES, CODE
;;;;
;;;;	
;;;;	Environment address convention : three tags.
;;;;	  1. System and Release, eg FDL0
;;;;	  2. Conventionial Configuration, eg LIB, EDD, REF, LIBREF.
;;;;	  3. Orb Name, eg TEST, RICH, SFA, JYH, SFA-EDIT.
;;;;
;;;;	
;;;;	FTTB : add-hoc solution for identify table-types produced within env.
;;;;	will be to provide function to declare production table types.
;;;;	There is no protection against incorrect declarations.

;;;;	orb_map_links : 
;;;;	orb_show_links : unit -> (int # int) list
;;;;	  * input # output : can be same.
;;;;	  * 0 => not available.
;;;;	
;;;;	Once connected messages can not be sent on link until a remote
;;;;	environment address is associated with the link. This can be done by
;;;;	the remote site or it may be done locally.
;;;;	
;;;;	?? orb_assoc_environment_address : int -> tok list -> unit
;;;;	??   * inform orb of remote environment address.
;;;;	?? ** this may be of limited utility. We should rely on remote orb
;;;;	??    to inform connected orbs of environments.
;;;;
;;;;	
;;;;	orb_send_environment_address : tok list -> tok list -> unit
;;;;	  * tok list : destination boot address
;;;;	  * tok list : source address to be added.
;;;;	  ** inform remote orb of environment address.
;;;;
;;;;	orb_revoke_environment_address : tok list -> tok list -> unit
;;;;	  * tok list : destination boot address
;;;;	  * tok list : source address to be removed.
;;;;	  ** inform remote orb of environment address.
;;;;
;;;;	orb_send_environment_table_types : tok list -> tok list -> tok list  -> unit
;;;;	  * tok list : destination boot env address.
;;;;	  * tok list : producer environment address
;;;;	  * tok list : table-types which can be served by producer environment.
;;;;	  ** inform remote orb of local produce, sets field does not append.
;;;;	    Does not correspond to resources in source environment. An environment
;;;;	    can serve a resource without containing it, and it may contain a resource
;;;;	    without serving it.
;;;;
;;;;	orb_revoke_environment_table_types : tok list -> tok list -> tok list  -> unit
;;;;	  * tok list : destination boot env address.
;;;;	  * tok list : producer environment address
;;;;	  * tok list : table-types which can be served by producer environment.
;;;;	  ** inform remote orb of local produce.
;;;;	    Does not correspond to resources in source environment. An environment
;;;;	    can serve a resource without containing it, and it may contain a resource
;;;;	    without serving it.
;;;;	
;;;;	orb_bus_environments : unit -> (tok list) list
;;;;	orb_local_environments : unit -> (tok list) list
;;;;	  * address list
;;;;	
;;;;	environment_table_types : tok list -> tok list
;;;;
;;;;
;;;;	environment funcs : ie evaluated within an env.
;;;;	
;;;;	env_start_broadcasts : tok-list -> tok list -> tok list -> unit 
;;;;	  * tok list : producer address
;;;;	  * tok list : consumer address
;;;;	  * tok list : resources to be served.
;;;;
;;;;	env_stop_broadcasts : tok-list -> tok list -> tok list -> unit 
;;;;	  * tok list : producer address
;;;;	  * tok list : consumer address
;;;;	  * tok list : resources being served.
;;;;
;;;;	env_suspend_broadcasts : tok-list -> tok list -> tok list -> unit 
;;;;	env_restart_broadcasts : tok-list -> tok list -> tok list -> unit 
;;;;
;;;;	** start will cause dump of current table states. Suspend will
;;;;	   cause queueing of broadcasts. Restart will release queue.
;;;;	


(defun fooe () (raise-error (error-message '(foo))))

;;;
;;;	Boot environment:
;;;

(defun orb-init ()
  (set-orb-sleeper nil)
  (unless (component-environment-p (orb-address))
    (add-environment (new-environment (orb-address) '(orb) nil nil nil))
    (setf *orb* (find-environment-in-list (orb-address) *component*))
    ))


(defun cleanup-com (&optional (delete-component-p t))
  (setf *message-stores* nil
	*default-message-store* nil)

  (orb-cleanup delete-component-p)
  nil
  )

    
(defun send-quit-loop (type address)
  (orb-eval type address
	    (iexpression-term
	     (iml-woargs-term nil nil (itext-term "quit_request_loop()")))))



(defun ping (link term)
  (advance-sequence)
  (link-send link (iping-term (current-sequence) term))
  (link-recv link t))

;; LAL TODO: ping not yet tested with new stream implementation

#|
(defun stream-open-ping-close (term count &optional (port 2890) (host "alfheim"))
  (let ((link (new-term-stream-link (list (cons nil (new-socket port host nil))))))
    
    (link-open link)
    (time
     (dotimes (i count)
	      (ping link term)))
    (link-send link (ivoid-term))
    (link-close link)))

(defun stream-ping-wait (&optional (port 2890))
  (let ((link (new-term-stream-link (list (cons (new-socket (or port 2890) nil t) nil)))))
    
    (link-open link)
    (prog1 (link-recv link t)
      (link-close link))))

(defun tt-open-ping-close (term count)
  (let ((link (new-term-tt-link nil nil)))
    (link-open link)
    (time
     (dotimes (i count)
       (ping link term)))
    (link-send link (ivoid-term))
    (link-close link)))

(defun tt-ping-wait ()
  (let ((link (new-term-tt-link nil t)))
    (link-open link)
    (link-recv link t)
    (link-close link)))
|#

(defun ping-test (&optional (n 0) (count 100) (tt-p t) port)
  (let* ((a (itext-term "12345678901234567890123456789012345678901234567890"))
	 (b (icons-term a a))
	 (c (icons-term b b))
	 (d (icons-term c c))
	 (e (icons-term d d))
	 (f (icons-term e e))
	 (g (icons-term f f))
	 (h (icons-term g g))
	 (i (icons-term h h))
	 (j (icons-term i i))
	 (k (icons-term j j))
	 (terms (list a b c d e f g h i j k))
	 (term (nth n terms)))
    (when term
      (if (> count 0)
	  (progn
	    (if tt-p
		(tt-open-ping-close term count)
		(stream-open-ping-close term count port))

	    (let ((len (let ((count 0))
			 (walk-term-ascii term
					  #'(lambda (byte)
					      (declare (ignore byte))
					      (incf count)))
			 count)))
				   
	      (format t "~% ~a messages of length ~:D sent.  Total Bytes ~:D.~%" count len (* len count))
	      nil))
	  term))))



#+(or lucid allegro)
(shadow '(quit))

;;#+allegro
;;(shadow '(exit))

;;#+lucid
;;(defun quit ()
;;  (close-io-trace-file)
;;  (lcl:quit))

;;#+allegro
;; following def just loops when quit called.
;;(defun quit ()
  ;;(format t "q")
  ;;(close-io-trace-file)
  ;;(cl-user::quit))




;;;;	start lib.
;;;;	
;;;;	
;;;;	
;;;;	
;;;;	



(defun orb-eval-in-server (value-p args-p expr args)
  (let* ((term (iexpression-term (if args-p
				     (iml-term nil value-p expr args)
				     (iml-woargs-term nil value-p expr))))
	 (rsp (orb-eval 'server
			(or (let ((e (and (in-environment-p) (current-environment))))
			      (and e (server-address-of-environment e)))
			    (address-of-environment
			     (match-bus-environment '(ORB))))
			term
			(not (in-environment-p)))))
    
    (interpret-result rsp)))





(defmacro withpm (&body body)

  `(with-handle-error-and-message ((nil) #'(lambda (m)
					     (when m (print-message m))
					     (mapc #'print-message (messages-flush))
					     nil
					     ))
    ,@body))
