% HOL port 11/2003 file orignally was named hol-tactics. %

letref quick_auto = false ;;

let fresh_var root p =
  new_var (tok_to_var root) (declared_vars p)
;;

let fresh_vars root n p =
  let v = tok_to_var root in
  letrec f i l l' = if i<1 then l
                    else let x = new_var v l' in f (i-1) (x.l) (x.l') in
  f n [] (declared_vars p)
;;


let fresh_vars_for_term root n t =
  let v = tok_to_var root in
  letrec f i l l' = if i<1 then l
                    else let x = new_var v l' in f (i-1) (x.l) (x.l') in
  f n [] (all_vars t)
;;



% Decomposes a tactic arg which specifies a term with its type,
  via a type_tag term or a member term.  get_type is called
  if the term is not one of these two kinds. %
let term_with_type p t =
  if is_member_term t then subterm t 2, subterm t 1
  if is_term `type_tag` t then subterm t 1, subterm t 2
  else t, get_type p t
;;

update_Auto_additions `quick_auto` 
  (\p. if quick_auto then IfLab `wf` Fiat Fail p else fail) 
;;

ml_curried_infix `THEND` ;;

let $THEND T1 T2 p = 
  let c = concl p in
  (T1 THEN If (\p'. not c = concl p') T2 Id) p
;;

let DeadVar i p =
  let x = var_of_hyp i p in
  if `%` = hd (explode (var_to_tok x)) or
     exists (\t. member x (free_vars t))
            (concl p . map (\i. h i p) (upto (i+1) (num_hyps p)))
  then Id p else Thin i p
;;

let DeadVars p =
  On (rev (upto 1 (num_hyps p))) DeadVar p
;;

tac_debug := false ;;

% tc{f,g} = type checking {formula,goal} %
let tcf_term t = snd (dest_member t) ;;
let tcf_type t = fst (dest_member t) ;;

let WhenTCGTypeKind opid T = IfOnConcl (\c. opid = opid_of_term (tcf_type c)) T Fail ;;
let WhenTCGTermKind opid T = IfOnConcl (\c. opid = opid_of_term (tcf_term c)) T Fail ;;
let WhenTCGKinds opid1 opid2 T = 
  IfOnConcl (\c. opid1 = opid_of_term (tcf_term c)
                 & opid2 = opid_of_term (tcf_type c)) 
            T 
            Fail ;;

let ProveHAbWf name abs_to_expand =
  let thm_name = name J "_wf" in
  let p = mk_proof_refined_by_tactic
            (goal_of_thm_object (string_to_tok thm_name))
            (concatenate_strings
              ("Unfolds ``"
               . name
               . map (\x. " " J x) abs_to_expand @ ["`` 0 THEN Auto"]
              )) in
  insert_proof_in_thm_object p (string_to_tok thm_name) 
;;

let genvar root_string p =
  new_var (mkv (string_to_tok root_string)) (declared_vars p)
;;

let is_hbool_term t = opid_of_term t = `hbool` ;;

% FDL port: moved to tacticals
ml_curried_infix `THENw` ;;

let $THENw T1 T2 = 
  T1 THEN IfLab `wf` Id T2 
;;
%


% Fixed version of Paul's tactic.  In the HOL lib, universes for types 
  can be S, in which case At will use a default, but Paul assumes wf goals 
  have exactly the universe from At.   Insert "Try". %
%FDL port: integrated with NewGenConcl %
let HolGenConcl t_eq_x_in_T p =
  let T,t,x = dest_equal t_eq_x_in_T
              ? let t,T = term_with_type p t_eq_x_in_T in
                 T, t, mvt (fresh_var `x` p) in 
  let new_concl = replace_subterm t x (concl p) in
  let seq_term =
    % All x:T. x=t in T => C[x/t] % 
    mk_all_term (dv x) T (mk_implies_term (mk_equal_term T t x) new_concl)   in
  let t_in_T = mk_member_term T t in
  let U = get_universe p T in
  let T_in_U = mk_member_term U T in

( AssertL [t_in_T; T_in_U; seq_term]
  THENL
  [% >> t in T % AddHiddenLabel `wf`
  ;% t in T,  >> T in U % Thin (-1) THEN AddHiddenLabel `wf`
  ;% t in T, T in U >> all x:T. x=t in T => C[x/t] %

   (At U (D 0) THENA Try (NthHyp (-1)))

   % t in T, T in U, x:T >> x=t in T => C[x/t] %
   THENw
   (At U (D 0) THENA (MemCD THEN (Try Trivial)))

   % t in T, T in U, x:T, x=t in T => C[x/t] %
   THENw
   OnHyps [-3;-3] Thin

  ;% t in T, T in U,  all x:T. x=t in T => C[x/t] >> C %

   SeqOnSameConcl [DTerm t (-1); D (-1)] THEN Trivial
  ]
) p
;;


let GenThen t Tac p =
  let t',T = term_with_type p t ? failwith `GenThen: type inference.`  in
  let T' = unfold_soft_abs T in
  let x = mvt (genvar "x" p) in
  (GenConcl (mk_equal_term T' t' x) THENM (Thin (-1) THEN Tac (-1)))
  p
;;

let GenDC t p = GenThen t (\i. D i THEN Reduce 0) p ;;

%[
let HBoolD i = 
  if i=0 then MemTypeCD ORELSE EqTypeCD
  else D i THENM (Unhide THENM Folds ``ht hf`` (i+1) THENM D (i+1))
;;
]%

let HBoolD i = 
  if i=0 then failwith `HBoolD only applies to hyp clauses`
  else MoveToConcl i THEN BackThruLemma `hbool_cases`
;;

let NormPropHyps = Repeat (Progress (TryOnAllHyps GenExistHD)) ;;

let L = BackThruLemma ;;

let RL x = SwapEquands 0 THEN L x ;;

lettype rrule = term + (int + tok) ;;

let eq_rule x : rrule = inl x ;;
let hyp_rule x : rrule = inr (inl x) ;;
let lem_rule x : rrule = inr (inr x) ;;

let rrule_cases r eqf hypf lemf =
  eqf (outl r) ? hypf (outl (outr r)) ? lemf (outr (outr r))
;;

let RWOnce r i j =
  rrule_cases r
    (\eq. Assert eq THENL [Id; RW (NthC j (HypC (-1) ORELSEC RevHypC (-1))) i])
    (\k. RW (NthC j (HypC k ORELSEC RevHypC k)) i)
    (\name. RW (NthC j (LemmaC name ORELSEC RevLemmaC name)) i)  
;;

let LRWOnce name i j = RWOnce (lem_rule name) i j ;;

let HypNormCFrom l p =
  let Rs = map (\i. ProgressC (TryC (HypC i))) l in
  RW (RepeatC (DepthC (FirstC Rs))) 0 p
;;
  

let HypNormC p = HypNormCFrom (upto 1 (length (hyps p))) p ;;

let HBoolCleanup = TryOnAllClauses (Unfolds ``t f``) THEN EqTypeCD THENM Complete Auto ;;

% hyps should be in increasing order. %
let HBoolCasesOver hyps =
  OnMHyps (rev hyps) HBoolD 
;;

%[
let HBoolCasesOver hyps =
  OnMHyps (rev hyps) HBoolD 
  THENM HypNormC 
  THEN IfLab `rewrite subgoal` (Try HBoolCleanup) Id
;;
]%

let HBoolCases p = 
  let bvars = map fst (filter (\x,T,(). is_hbool_term T)
                              (map dest_declaration (hyps p)))  in
  HBoolCasesOver (map (C get_decl_num p) bvars) p
;;

let HBoolTermCases t p =
  let T =  get_type p t ? failwith `TermCase: type inference` in 
  if not (is_hbool_term T) then fail
  else GenThen t (\i. HBoolCasesOver [i]) p
;;

let BoolBlast = HBoolCases THENM RW NormalizeC 0 ;;

let SavePf = Mark `SomESAVEDPROOOF` ;;
let RestPf = Copy `SomESAVEDPROOOF` ;;

let RAll T = Repeat (Progress (All T)) ;;

let SquashC p = 
  (Assert (mk_squash_term (concl p)) THENM D (-1))
  p
;;


let LNorm lemmas rev_lemmas = 
  RW (NormC (FirstC (map SimpleCondC lemmas 
                   @ map RevSimpleCondC rev_lemmas))) 
;;


let Properties t p = 
( Assert (mk_member_term (get_type p t) t)  THENL
  [Id
  ;AddProperties (-1)
  ]
) p
;;

%declare_equiv_rel `iff` `equal` ;; %

let EquandMap f T i =
  let x,b = dest_lambda f in
  ApFunToHypEquands x b T i THEN Reduce (-1)
;;

let UnabSome clauses toks =
  OnClauses clauses (\i. Repeat (Progress (Unfolds toks i)))
;;

let Unab toks p = UnabSome (0 . upto 1 (num_hyps p)) toks p ;;

let UnAb = Unab ;;

let TypedSORedexC e t =
  if is_term `so_apply` t & is_term `tlambda` (hd (subterms t))
  then (NthSubC 1 UnfoldTopAbC 
        ANDTHENC UnfoldTopAbC
        ANDTHENC RepeatForC (length (subterms t) -1) RedexC
       ) e t
  else failwith `TypedSORedexC`
;;

let TypedSOReduceC = SweepUpC (TryC TypedSORedexC) ;;


let t_abstract t T p =
  let x = fresh_var `x` p in
  let body = let t = replace_subterm t (mvt x) (concl p) in
             if alpha_equal_terms t (concl p) then failwith `t_abstract: subterm doesnt occur.`
             else t  in
  mk_apply_term (mk_term (`tlambda`,[]) [[],T; [x],body])
                t
;;

let t_abstract_2 t T u =
  let [x] = fresh_vars_for_term `x` 1 u in
  let body = let t = replace_subterm t (mvt x) u in
             if t = u then failwith `t_abstract: subterm doesnt occur.`
             else t  in
  mk_apply_term (mk_term (`tlambda`,[]) [[],T; [x],body])
                t
;;

let TAbstract t T p =
  let new_concl = t_abstract t T p in
  let T2 p = (UnfoldAtAddr [1] (-1) THEN
              ReduceAtAddr [] (-1) THEN
              NthHyp (-1)) p
             ? failwith `TAbstract: bug!`  in
  (Assert new_concl THENL [Id;T2]) p
;;

let LElimTermUsing name t T p =
  let Tac p = L name p
              ? failwith `LElimTermUsing: lemma `^name^` doesnt apply.`  in
  (TAbstract t T THEN Tac THENM RW TypedSOReduceC 0) p
;;

let LElimTerm name t p =
  let T = get_type p t 
          ? failwith `LElimTerm: cant compute type.  Use LElimTermUsing`  in
  LElimTermUsing name t T p
;;

let logic_norms =  
``hall_iff_all hexists_iff_exists hnot_iff_not hor_iff_or 
  hand_iff_and himplies_iff_implies hequal_iff_equal``
;;

let UnaryHDef p = 
  RepeatM
  (Progress
    (RepeatM (D 0) THENM
     LNorm logic_norms [] 0 THENM
     RepeatM (Ext THENM Reduce 0) THENM
     Try (Complete 
          (\p. (Unfold (opid_of_term (fst (snd (dest_equal (concl p))))) 0 THEN Auto) p)))) p
  
;;

% FDL PORT integrated with base code	  
get_universe_hook := 
\p t. if opid_of_term (get_type p t) = `stype` then get_type p mk_int_term else fail
;;

containing_universe_hook :=
\t. if opid_of_term t = `stype` then  get_type pf mk_int_term else fail
;;
%

let HIndInd i = 
  D i THEN MoveToConcl (i+1) THEN 
  NonNegIntInd (mk_integer_term 0) i
;;
    
let SubtermC s C = 
  let C' e t = if alpha_equal_terms s t then C e t else failwith `SubtermC` in
  HigherC C'
;;

% FDL port - soft_abstractions different. hol_soft_types apparently not used.
let hol_soft_types () = filter (C mem soft_abstractions) (get_info `hol_type`) ;;
%

%[ Find all occurrences of terms t with
   opid, find the corresponding types by applying typer, then for each distinct
   pair (t,type), rewrite the whole term replacing t by a universally-quantified
   variable.  This rewrite should only be applied under the type-qf prefix of
   HOL imports.
]% 

%[
let AbstractMarkedArgsC opid typer conv e t =


]%

let HNC = SimpsetC ``hol_to_nuprl`` ;;

let HN = Simpsetp ``hol_to_nuprl`` ;;

let H i j = Rewrite (NormC (HypC i)) j ;;
let RevH i j = Rewrite (NormC (RevHypC i)) j ;;

let UnfoldFirst name i = Rewrite (NthC 1 (UnfoldTopC name)) i ;;

let ThenNth T n T' p =
  let pl,v = T p in
  let m = length pl in
  if n<1 or n>m then failwith `ThenNth: index out of range.`
  else ( (\p. pl,v) THENL replicate Id (n-1) @ [T'] @ replicate Id (m-n) 
       ) p
;;
  
let DLeft = DNth 1 0 ;;
let DRight = DNth 2 0 ;;

let Case disjunct =
  let terms = dest_iterated_or disjunct in
  letrec T terms = 
         if length terms < 2 then Id 
         else Decide (hd terms) THENML [Try DLeft; Try (DRight THENM T (tl terms))]  in
  ThenNth (Cases terms) 1 (T terms)
;;
          
let CAuto = Try (Complete Auto) ;;          

let Binding l = Using (map (\x,y. mkv x,y) l) ;;

letrec SomeDisjunct T p =
  if not is_or_term (concl p) then T p
  else ((DLeft THENM SomeDisjunct T) ORELSE (DRight THENM SomeDisjunct T)) p
;;

let RD pr i = RepeatIf (\g. pr (h i g)) (D i) ;;

let AtomizeHypPropsWrt preds =
  Repeat (All (IfOnHyp (\t. exists (\pr. pr t) preds) D (K Id)))
;;

let AtomizeHypProps =
  AtomizeHypPropsWrt [is_or_term; is_exists_term; is_and_term] 
;;

letrec CDTerms t p = 
  if is_nil_term t then Id p 
  else (DTerm (subterm t 1) 0 THENM CDTerms (subterm t 2)) p
;;

letrec HypSubst0 l p = 
  if null l then Id p else
  (HypSubst (hd l) 0 THENM HypSubst0 (tl l)) p
;;

% Don't use this!  Only for compatibility.  %
let HS0 = HypSubst0 ;;

let CollapseVarEq i p =
( let (), x, y = dest_equal (h i p) in
  let v,Start = if is_var_term x then dest_var x, Id
                if is_var_term y then dest_var y, SwapEquands i
                else fail  in
  letref failed_p = false in
  let Sub j p = if member v (free_vars (snd (clause j p))) 
                then (HypSubst i j p ? (failed_p := true; Id p))
                else Id p in
  let ThinIt p = if failed_p then Id p else Thin i p in
  ( Start
    THEN On (upto 1 (i - 1) @ upto (i+1) (num_hyps p)) Sub
    THEN Sub 0
    THEN ThinIt
  ) p
) ?\id failwith `CollapseVarEq: `^ id
;;

let find_hyp f p = 
  find (f o C h p) (upto 1 (num_hyps p))
;;


let CollapseVarEqs p =
  let eqs = filter (\t. is_equal_term t &
                        let (),x,y = dest_equal t in is_var_term x or is_var_term y)
                   (types_of_hyps p) in
  SeqOnM
    (map (\t. \p. CollapseVarEq (find_hyp ($= t) p) p)
         eqs)
    p
;;

let nil_sequent = mk_sequent [] mk_nil_term ;;

let mk_fun_term a b = mk_function_term null_var a b ;;

let t_abstract_eq_pred t =
  let e = find_subterm (is_term `eq_pred_marker` o snd) t in
  let a = addressed_subterm e [1;1] in
  %let T = mk_fun_term a (mk_fun_term a (mk_simple_term `bool` [])) in%
  let T = mk_simple_term `eq_pred` [a] in
  t_abstract_2 e T t
;;

let TAbstractEqPredC e t =
  MacroC `TAbstractEqPredC` IdC t TBetaC (t_abstract_eq_pred t) e t
;;

let EqPredSimpC e t =
  (TAbstractEqPredC ANDTHENC LemmaC `eq_pred_abstraction`
   ANDTHENC NthC 1 TBetaC) e t
;;

let RecUnfoldNth i tok = RW (NthC i (RecUnfoldTopC tok)) ;;


let htrue_op = `assert` ;;

let dest_alls = iterate_dest_quantifier dest_all ;;

% Goal must be a universally quantified htrue. %
let AssumeHOLProp p =
( let qfs,t = dest_alls (concl p) in
  if not is_term htrue_op t then failwith `AssumeHOLProp: unrecognized goal.`
  else UseWitness (mk_iterated_lambda (map fst qfs) mk_axiom_term)
       THEN Fiat
) p
;;
  

%FDL port : taken form import.ml %

let HOL name p =
 %FDL port  : probably worth porting import.ml %
 %check_hthy (find_thm_hthy name) ;
  if concl p = find_thm_goal name then AssumeHOLProp p
  else fail%

  AssumeHOLProp p
;;



% from patches%
let BoolCasesOnCExp_hol e p = 
  let b = get_distinct_var (mkv `bb`) p 
  in let eq_term =  
        (mk_equal_term  
          (mk_simple_ab_term `bool` []) 
          e 
          (mk_var_term b) 
        )     
  in 
  SeqOnM 
    [GenConcl eq_term 
    ;BoolInd (-2) 
    %[ ; Rewrite bool_to_propC (-1) ]% 
    ] 
    p 
;; 
