#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)


;;; After rewriting the simplifier, we had version problems.  Rather
;;; than doing it write, and fixed Nuprl to handle this kind of dependency
;;; tracking, we hack, creating new copies of the simp tables so that
;;; both versions can coexist simultaneously.  The old simp uses stuff
;;; prefixed OLD.


;;; OLD

(defvar *OLD-op-to-simps-table*
  (make-hash-table :test #'eq :size 2000))

(defunml (|OLD_clear_op_to_simps_table| (foo) :declare ((declare (ignore foo))))
  (void -> void)

  (clrhash *OLD-op-to-simps-table*)
  nil)

(defunml (|OLD_op_to_simps_table_lookup'| (key))
    (tok -> *)
  (gethash key *OLD-op-to-simps-table*))

(defunml (|OLD_op_to_simps_table_replace'| (key simps))
  (tok  -> (* -> unit))
  (if (null simps)
      (remhash key *OLD-op-to-simps-table*)
      (setf (gethash key *OLD-op-to-simps-table*) simps))
  nil)

(defunml (|OLD_list_of_op_to_simps_table'| (foo) :declare ((declare (ignore foo))))
  (unit -> (* list))

  (let ((res nil))
    (maphash #'(lambda (key value) (push value res)) *OLD-op-to-simps-table*)
    res))

(defvar *OLD-id-to-simp-table*
  (make-hash-table :test #'eq :size 2000))

(defunml (|OLD_clear_id_to_simp_table| (foo) :declare ((declare (ignore foo))))
  (void -> void)
  (clrhash *OLD-id-to-simp-table*)
  nil)

(defunml (|OLD_id_to_simp_table_lookup'| (key))
  (tok -> *)
  (let ((res (gethash key *OLD-id-to-simp-table*)))
    (unless res
      (breakout evaluation "id_to_simp_table: not found"))
    res))

(defunml (|OLD_id_to_simp_table_replace'| (key simp))
  (tok  -> (* -> unit))
  (setf (gethash key *OLD-id-to-simp-table*) simp))

(defunml (|OLD_id_to_simp_table_delete| (key))
  (tok -> unit)
  (remhash key *OLD-id-to-simp-table*))

(defunml (|OLD_list_of_id_to_simp_table'| (foo)  :declare ((declare (ignore foo))))
  (unit -> (* list))
  (let ((res nil))
    (maphash #'(lambda (key value) (push value res)) *OLD-id-to-simp-table*)
    res))


;;; NEW.

(defvar *op-to-simps-table*
  (make-hash-table :test #'eq :size 2000))

(defunml (|clear_op_to_simps_table| (foo) :declare ((declare (ignore foo))))
  (void -> void)

  (clrhash *op-to-simps-table*)
  nil)

(defunml (|op_to_simps_table_lookup'| (key))
  (tok -> *)
  (gethash key *op-to-simps-table*))

(defunml (|op_to_simps_table_replace'| (key simps))
  (tok  -> (* -> unit))
  (if (null simps)
      (remhash key *op-to-simps-table*)
      (setf (gethash key *op-to-simps-table*) simps))
  nil)

(defunml (|list_of_op_to_simps_table'| (foo) :declare ((declare (ignore foo))))
  (unit -> (* list))

  (let ((res nil))
    (maphash #'(lambda (key value) (push value res)) *op-to-simps-table*)
    res))


(defvar *id-to-simp-table*
  (make-hash-table :test #'eq :size 2000))

(defunml (|clear_id_to_simp_table| (foo) :declare ((declare (ignore foo))))
  (void -> void)

  (clrhash *id-to-simp-table*)
  nil)

(defunml (|id_to_simp_table_lookup'| (key))
  (tok -> *)
  (let ((res (gethash key *id-to-simp-table*)))
    (unless res
      (breakout evaluation "id_to_simp_table: not found"))
    res))

(defunml (|id_to_simp_table_replace'| (key simp))
  (tok  -> (* -> unit))
  (setf (gethash key *id-to-simp-table*) simp))

(defunml (|id_to_simp_table_delete| (key))
  (tok -> unit)
  (remhash key *id-to-simp-table*))

(defunml (|list_of_id_to_simp_table'| (foo) :declare ((declare (ignore foo))))
  (unit -> (* list))

  (let ((res nil))
    (maphash #'(lambda (key value) (push value res)) *id-to-simp-table*)
    res))


(defvar *simp-id-to-location-table*
  (make-hash-table :test #'eq :size 2000))

(defunml (|clear_simp_id_to_location_table| (foo) :declare ((declare (ignore foo))))
  (void -> void)

  (clrhash *simp-id-to-location-table*)
  nil)

(defunml (|simp_id_to_location_table_lookup| (key))
  (tok -> tok)
  (let ((res (gethash key *simp-id-to-location-table*)))
    (unless res
      (breakout evaluation "simp_id_to_location_table: not found"))
    res))

(defunml (|simp_id_to_location_table_replace| (key location))
  (tok  -> (tok -> unit))
  (setf (gethash key *simp-id-to-location-table*) location))

(defunml (|simp_id_to_location_table_delete| (key))
  (tok -> unit)
  (remhash key *simp-id-to-location-table*))

(defunml (|list_of_simp_id_to_location_table| (foo) :declare ((declare (ignore foo))))
  (unit -> (tok list))

  (let ((res nil))
    (maphash #'(lambda (key value) (push value res)) *simp-id-to-location-table*)
    res))



;;;;;;;;;;;;;;;;;;;;  Some stuff not specific to simps ;;;;;;;;;;;;;;;;;;;;

(defunml (|substringp| (s1 s2))
	  (string -> (string -> bool))
  (search s1 s2))


(defunml (|apply_and_cleanup| (f x c))
  ((* -> **) -> (* -> ((void -> ***) -> **)))
    (unwind-protect (ap f x) (ap c nil)))