%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************
%

%;;;	
;;;;	visible_statements control which statements are visible
;;;;	  - todo : investigate which calls are thus protected.
;;;;	     supply some unprotected calls for non-refinement operations.
;;;;	
;;;;	
;;;;	caches could use lighter weight abs type since no inheritance.
;;;;	
;;;;	
;;;;	
;;;%
reset_get_ref_environment_f ();; 

letref visible_statements_ref_state = 
  new_simple_ref_state `visible_statements` append (nil : object_id list);;
let get_visible_statements index = ref_state_get visible_statements_ref_state index;;

let maybe_name_of_lemma oid = (name_of_lemma oid ? null_token);;

let get_visible_statments_names index = 
  map maybe_name_of_lemma (get_visible_statements index)
;;

let toks_with_prefix prefix = filter (match_tok_with_prefix prefix);;

let visible_statements_with_prefix prefix index =
   toks_with_prefix prefix (get_visible_statments_names index)
;;

let current_visible_statements_with_prefix prefix =
  visible_statements_with_prefix prefix (current_ref_environment_index `visible_statements`)
;;

let lookup_visible_statements () = 
  get_visible_statements (current_ref_environment_index `visible_statements`)
;;
let lookup_visible_statements_names () = 
  map (\oid. (name_of_lemma oid ? null_token)) (lookup_visible_statements());;

update_ref_state_view
 (\(). visible_statements_ref_state)
 (ref_state_view_list_entry ioid_term)
;;     

%
;;;;	
;;;;	bool.
;;;;	
;;;;	
;;;;	letref  fu_p = or_ref_state name
;;;;	
;;;;	if last update false or all prevs false then false otherwise true.
;;;;	???
%

let or_ref_state name = 
 let myor a b = a or b in
 % major kludge :
    expect only to be called when updates with single prev, since merges done
    distinctly. Will be a problem if multiple prevs with updates.??
 %
 let myor2 a b = a in
  new_ref_state name 
    (\l. if null l then true else last l)
    myor2
    (nil: (object_id # bool) list)
    true
;;

let or_ref_state_merge name or_rs index edges =
 ref_state_set or_rs index
    (reduce (\a b. a or b) true
            (map (ref_state_get or_rs) (resolve_edges name edges)))
;;
   
let or_ref_state_p name rs index = 
 ref_state_get rs (ref_state_index_deref name index)
;;

%
;;;;	
;;;;	tac caches
;;;;	
%
 
lettype bool_to_tac_cache = (tok # ((bool -> tactic) list)) list;;

% note : only works reliably if list to be sorted is length 2 %
let refleqcd_precedes_p a b =
 tty_print "refleqcd precedes" ;
 (let oid = oid_of_ioid_term (ref_get_substantive_property `precedes_in_refleqcd_cache` a) in
   if equal_oids_p oid b
     then (tty_print "refleqcd precedes true"; true)
     else (tty_print "refleqcd precedes false"; false))
  ? false		      
;;

% true if lemma1 is more general than lemma2
  false if lemma2 is more general than lemma1
  fails otherwise.

  if lemma1 is more general then it should
  com later in the sequence of wfs.
%  
let refleqcd_match_order oid1 oid2 =
 letrec find_mem t =
   if is_term `member` t then t
   else if (member (id_of_term t) ``all implies``)
	   then find_mem (subtermn 2 t)
   else fail in	   
 let t1 = find_mem (statement_lookup oid1)
 and t2 = find_mem (statement_lookup oid2) in
 let fv1 = free_vars t1 
 and fv2 = free_vars t2 in
  if (can (match fv1 t1) t2)
     then if (can (match fv2 t2) t1) then fail else true
     else if (can (match fv2 t2) t1) then false else fail
;;

let refleqcd_pairwise_match_graph l =
 letrec aux a l =
  if null l then nil else
   let b = hd l in 
     ( ( (if (refleqcd_match_order a b) then (b,a) else (a,b))
       . aux a (tl l))
     ? aux a (tl l)) in

  letrec auxaux l =
   if (null l) then nil else
   (aux (hd l) (tl l)) @ auxaux (tl l) in

  let m = auxaux l in
   if (not (null m))
       then tty_print ( "Found " J (int_to_string (length m))
                      J " refleqcd matches in " J  (int_to_string (length l)) J " lemmas.");
   m       
;;   
 
% Even if a precedes b in Graph b may be used.
  ReflEqCDByLemma comes in two flavors(the bool arg), if a fails with first flavor
  and b works then b will be used in preference to a even thought
  b may have worked with second flavor.
%
let refleqcd_precedence_graph oids =
 let g =  map_omitting_failures
            (\oid. let order = ref_get_substantive_property `order_in_refleqcd_cache` oid in
                   let ordertok = first_tok order in
                     if ordertok = `precedes` then (oid, [first_oid order])
	             if ordertok = `suceeds` then (first_oid order, [oid])
	             if ordertok = `succeeds` then (first_oid order, [oid])
                     else fail)
          oids
  in

  % filter those not in oids which precede others %
  let g' = map (\oid. oid, ((apply_alist_p g oid equal_oids_p) ? nil))
               oids in
	       
  let mg = filter
   	      % give precedence to declared order %
	      (\ (a,b).
		  not (exists
		        (\ (c,d). %duplicate%     (equal_oids_p a c & member_p b d equal_oids_p)
			       or %contradiction% (equal_oids_p b c & member_p a d equal_oids_p))
			g))
               (refleqcd_pairwise_match_graph oids) in
  % update graph with match graph %
  map (\a,l. (let b = apply_alist_p mg a equal_oids_p in
	     a,  b.l)
	    ? a,l)
      g'
;;


let cache_update_aux matchf build index ecache id = 
 let cache = ref_state_get ecache index in
 let loids = get_visible_statements index in
 %let sloids = if (length loids) = 2
                 then (quicksort refleqcd_precedes_p loids)
		 else loids in
 %%%% could sort here !! %
 let f = matchf id in
 let nameoids = mapfilter
                 (\oid.
                   let name = name_of_lemma oid ? null_token in
	             if f (tok_to_string name)
		        then name, oid
			else fail)
                 (get_visible_statements index) in
 %tty_print ("refleqcd_precedes call " J (int_to_string (length nameoids)));%
 let idnames = if (length nameoids) > 1 
                  then map (\oid. rev_apply_alist_p nameoids oid equal_oids_p)
                                 (let oids = map snd nameoids in
   			           (flatten (rev (layered_oids (refleqcd_precedence_graph oids) oids))))
			   %
			   (quicksort (\ (namea,oida) (nameb,oidb). refleqcd_precedes_p oida oidb) 
                                           nameoids)
			   %
                  else (map fst nameoids) in


 %let names = map (\oid. (name_of_lemma oid ? null_token)) sloids in

  let idnames = filter (\name.  (matchf id) (tok_to_string name)) names in
  % 
  let items = (build index idnames) in
     items, (ref_state_modify ecache index ((id, items) . cache) nil)
;;

let cache_update_singleton_aux matchf build index ecache id = 
 let cache = ref_state_get ecache index in
 let names = map (\oid. (name_of_lemma oid ? null_token)) (get_visible_statements index) in

  let item = ( inr (build index id (find (\name. (matchf id (tok_to_string name))) names))
             ? inl ()) in
     item, (ref_state_modify ecache index ((id, item) . cache) nil)
;;

let ref_cache_lookup_aux_aux eqp updatef get set build id =
 let index = (current_ref_environment_index `visible_statements`) in
 let ecache = get () in
 let cache = ref_state_get ecache index in
  (apply_alist_p cache id eqp)
  ?
  let items, ncache = updatef build index ecache id in
   set ncache;
   items
;;

let ref_cache_lookup_aux =  ref_cache_lookup_aux_aux $=;;

let build_cache_match kind id = 
  string_match_f true (concatenate_strings [tok_to_string id; "_"; kind])
;;

let build_cache_prefix_match kind id = 
  string_match_f true (concatenate_strings ["^"; tok_to_string id; "_"; kind])
;;

let build_exact_cache_match kind id = 
  string_match_f true (concatenate_strings ["^"; tok_to_string id; "_"; kind; "$"])
;;

let tac_cache_lookup_wf =
  ref_cache_lookup_aux
    (cache_update_aux (build_cache_prefix_match "wf"))
;;

let cache_lookup kind = 
  ref_cache_lookup_aux
     (cache_update_aux (build_cache_match kind))
;;

let cache_prefix_lookup kind = 
  ref_cache_lookup_aux
     (cache_update_aux (build_cache_prefix_match kind))
;;

let cache_ref_state_update_fail (a: * list) (b: * list) =
  if null b then a else
  (raise_error nil ``cache no inheritance`` nil; a)
;;

lettype bool_to_tac_cache = (tok # (bool -> tactic) list) list;;

let new_bool_to_tac_cache name =
  new_simple_ref_state name cache_ref_state_update_fail (nil : bool_to_tac_cache);;


%;;;	
;;;;	ReflEqCD/NonReflEqCD
;;;%


letref ReflEqCD_cache = new_bool_to_tac_cache `ReflEqCD_cache`;;

let declare_refl_cache index = 
 ReflEqCD_cache := declare_ref_state_data ReflEqCD_cache index nil nil
;;

update_ref_state_view
 (\(). ReflEqCD_cache)
 (ref_state_view_list_entry (itoken_term o fst))
;;
 

letref NonReflEqCD_cache = new_bool_to_tac_cache `NonReflEqCD_cache`;;

let declare_nonrefl_cache index = 
 NonReflEqCD_cache := declare_ref_state_data NonReflEqCD_cache index nil nil
;;

update_ref_state_view
 (\(). NonReflEqCD_cache)
 (ref_state_view_list_entry (itoken_term o fst))
;;

%;;;	
;;;;	inc/qinc
;;;;	
;;;;	??? might there be problems if visible_statements modified via additions mechanism.
;;;;	??? ie this should be reset (and probably others at mod time).
;;;;	fttb, expect visible_statements to not be modified via additions.
;;;%


letref inc_cache = new_simple_ref_state `inc_cache` append (nil: (tok # (tok list)) list);;

let declare_inc_cache index = 
 inc_cache := declare_ref_state_data inc_cache index nil nil
;;
let undeclare_inc_cache index = 
 (inc_cache := ref_state_remove inc_cache index; ())
 ? ()					
;;

update_ref_state_view
 (\(). inc_cache)
 (ref_state_view_list_entry (\t,ts. tokens_to_term (t . ts)))
;;



letref qinc_cache = new_simple_ref_state `qinc_cache` append (nil: (tok # (tok list)) list);;

let declare_qinc_cache index = 
 qinc_cache := declare_ref_state_data qinc_cache index nil nil
;;

let undeclare_qinc_cache index = 
 (qinc_cache := ref_state_remove qinc_cache index; ())
 ? ()
;;

update_ref_state_view
 (\(). qinc_cache)
 (ref_state_view_list_entry (\t,ts. tokens_to_term (t . ts)))
;;


%;;;	
;;;;	Decidable__lemmas
;;;%

letref Decidable__lemmas_assoc = new_simple_ref_state `Decidable__lemmas_assoc` append (nil : tok list);;

let ref_add_Decidable__lemmas_assoc_aux index edges items =
 Decidable__lemmas_assoc
    := declare_ref_state_data_indirect `Decidable__lemmas_assoc`
                                        Decidable__lemmas_assoc index items edges
;;

let ref_add_Decidable__lemmas_assoc index edges items =
 declare_ref_state_index index `Decidable__lemmas_assoc` index;
 ref_add_Decidable__lemmas_assoc_aux index edges items;
 ()
;;

let lookup_Decidable__lemmas () = 
  ref_state_get Decidable__lemmas_assoc (current_ref_environment_index `Decidable__lemmas_assoc`)
;;

update_ref_state_view
 (\(). Decidable__lemmas_assoc)
 (ref_state_view_list_entry itoken_term)
;;     



%;;;	
;;;;	sq_stable__lemmas
;;;%

letref sq_stable__lemmas_assoc = new_simple_ref_state `sq_stable__lemmas_assoc` append (nil : tok list);;

let ref_add_sq_stable__lemmas_assoc_aux index edges items =
 sq_stable__lemmas_assoc
    := declare_ref_state_data_indirect `sq_stable__lemmas_assoc`
                                        sq_stable__lemmas_assoc index items edges
;;

let ref_add_sq_stable__lemmas_assoc index edges items =
 declare_ref_state_index index `sq_stable__lemmas_assoc` index;
 ref_add_sq_stable__lemmas_assoc_aux index edges items;
 ()
;;

let lookup_sq_stable__lemmas () = 
  ref_state_get sq_stable__lemmas_assoc (current_ref_environment_index `sq_stable__lemmas_assoc`)
;;

update_ref_state_view
 (\(). sq_stable__lemmas_assoc)
 (ref_state_view_list_entry itoken_term)
;;     



%;;;	
;;;;	D_additions
;;;%

letref D_additions_assoc = 
 new_list_ref_state `D_additions_assoc`  (nil : (tok # (int -> tactic)) list)
;;

let ref_add_D_additions index edges items =
 declare_ref_state_index index `D_additions_assoc` index;
 D_additions_assoc 
    := declare_ref_state_data_indirect `D_additions_assoc`
				        D_additions_assoc index items edges
;;

let D_additions_add_data oid data =
  D_additions_assoc := ref_state_set_data D_additions_assoc [(oid, data)]
;;

let D_additions_do_updates oid edges oids =
  D_additions_assoc := ref_state_do_updates D_additions_assoc oid oids edges
; ()
;;
let undeclare_D_additions oid =
  (D_additions_assoc := ref_state_remove D_additions_assoc oid; ())
  ? ()
;;

let lookup_D_additions () = 
 ref_state_get D_additions_assoc (current_ref_environment_index `D_additions_assoc`)
;;

%;;;	
;;;;	Trivial_additions
;;;%

letref Trivial_additions_assoc = 
  new_list_ref_state `Trivial_additions_assoc` (nil :  (tok # tactic) list);;

let ref_add_Trivial_additions_aux index edges items =
 Trivial_additions_assoc 
   := declare_ref_state_data_indirect `Trivial_additions_assoc` Trivial_additions_assoc index items edges
;;

let ref_add_Trivial_additions index edges items =
 declare_ref_state_index index `Trivial_additions_assoc` index;
 ref_add_Trivial_additions_aux index edges items
;;

let ref_add_Trivial_additions_additions items index edges =
 Trivial_additions_assoc :=
    ref_state_modify_state Trivial_additions_assoc items index edges
 ; ()
;;

let lookup_Trivial_additions () = 
  ref_state_get Trivial_additions_assoc (current_ref_environment_index `Trivial_additions_assoc`)
;;


let Trivial_additions_add_data oid data =
  Trivial_additions_assoc := ref_state_set_data Trivial_additions_assoc [(oid, data)]
;;

let Trivial_additions_do_updates oid edges oids =
  Trivial_additions_assoc := ref_state_do_updates Trivial_additions_assoc oid oids edges
; ()
;;
let undeclare_Trivial_additions oid =
  (Trivial_additions_assoc := ref_state_remove Trivial_additions_assoc oid; ())
  ? ()
;;

let Trivial_additions_add oid data =
 add_ref_environment_data oid `Trivial_additions_assoc` Trivial_additions_add_data data
;;

update_ref_state_view
 (\(). Trivial_additions_assoc)
 (ref_state_view_list_entry (itoken_term o fst))
;;     


let decidable__visible_statements index = visible_statements_with_prefix "decidable__" index;;
let sq_stable__visible_statements index = 
  filter (\x. not (x = `sq_stable__from_stable`))
     (visible_statements_with_prefix "sq_stable__" index)
;;
