%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
BoolInd defined in induction-tactics.ml
%

let AllBoolInd p =
  let hs = map type_of_declaration (hyps p)  
  in let i_h_prs = zip (upto 1 (length hs)) hs 
  in let bool_is = 
        mapfilter
          (\i,h. if is_term `bool` h then i else fail)
          i_h_prs
  in 
     OnHyps (rev bool_is) BoolInd p
;;


let OpenBoolOps i p =
  Rewrite (UnfoldsC ``bimplies bxor bool_equal``
           ORTHENC UnfoldsC ``bnot band bor``
          )
          i
          p
;;

% BoolEval defined in Library %

%
let BoolEval p =
( OpenBoolOps 0 
  THEN AllBoolInd
  THEN Rewrite (RepeatC (HigherC ifthenelse_evalC))
) p
;;
%

% Use better name. Should change elsewhere too. %
let BoolCases p = BoolInd p
;;

let BoolSplit t = InstLemma `bool_cases` [t] THENM D (-1) ;;
