% 
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%
***************************************************************************
Special Term Manipulation Support 
***************************************************************************


We factor out unary and binary function applications. This simplifies
rewriting with respect to non-equality relations.

Txlation:

f is not either `apply` or `infix_ap` term.

ap(f;a) ==> f_opid(f;a)

ap(ap(f;a);b) ==> f_opid(f;a;b)

infix_ap(f;a;b) ==> f_opid(f;a;b)

%

letref atomic_n_ap_rw_alist = [] : ((tok # int) # tok) list ;;

%
Treat n-ary applications of term with opid as term apid with
n+1 subterms.
%

let treat_iterated_ap_as_atomic_for_rw opid n apid = 
  atomic_n_ap_rw_alist := 
    update_alist atomic_n_ap_rw_alist (opid,n) apid
  ; ()
;;

let rw_hd_and_arity_of_iterated_ap t = 
  letrec aux n t =
    if is_term `apply` t then
       aux (n+1) (snd (hd (bterms_of_term t)))
    else 
      t,n
  in 
  if is_term `infix_ap` t then
    snd (hd (bterms_of_term t)),2
  else
    aux 0 t
;;

%
Returns id,n where

n = 0, normal
n > 0, application to be treated specially.
%

let rw_opid_and_ap_arity_of_term t = 
  let hdt,n = rw_hd_and_arity_of_iterated_ap t in
  let hd_id = opid_of_term hdt in
  if is_bound (hd_id,n) atomic_n_ap_rw_alist then
    apply_alist atomic_n_ap_rw_alist (hd_id,n),n
  else
    opid_of_term t,0
;;



let rw_quick_dest_term t = 
  let (),n = rw_opid_and_ap_arity_of_term t in
  if not n = 0 & not (is_term `infix_ap` t) then
      inl(),terms_to_bterms (dest_iterated_apply t)
  else
    (inr # id) (dest_term t)
;;
  
let rw_quick_mk_term operator bterms = 
  if isl operator then
      mk_iterated_apply (bterms_to_terms bterms)
  else
    mk_term (outr operator) bterms
;;


% make sure added to Null environment:
add_env_update_fun 
  `apply`
  (\e t.let (),n = rw_opid_and_ap_arity_of_term t in
        if n = 0 then
          replicate e 2
        else
          replicate e (n + 1)
  )
;;
%

%
***************************************************************************
Compute sequence functions for use in conversionals.
***************************************************************************
%

%
merge_subterm_comp_seq_justs
  t : term  
  js : just list
  =
  j : just

%
let merge_subterm_compute_seq_justs t js
  =
  let term_op,bterms = rw_quick_dest_term t in
  let bvs_list = map fst bterms in
  let make_term subts = rw_quick_mk_term term_op (zip bvs_list subts) 
  in
  let cs_list = map open_comp_seq_just js in
  let cs_el_bunch_list = merge_compute_seqs cs_list 
  in
    form_comp_seq_just
    ( map
        (\compute_op,tagged_terms,tactics.
            compute_op, make_term tagged_terms, flatten tactics)
        cs_el_bunch_list
    )
;;      
%
join_comp_seq_justs 
  Ja:just 
  Jb:just 
  = 
  J:just 
%

let join_comp_seq_justs j1 j2 
  =
  let cs1 = open_comp_seq_just j1 in
  let cs2 = open_comp_seq_just j2 
  in
  form_comp_seq_just (append_compute_seqs cs1 cs2)
;;

let reverse_comp_seq_just j
  =
  let cs = open_comp_seq_just j 
  in
  form_comp_seq_just (reverse_compute_seq cs)
;;


%
convert_comp_seq_to_tactic 
  cs_j : just 
  = 
  tac_j : tactic
%


let convert_comp_seq_to_tactic j
  =
  let cs = open_comp_seq_just j
  in
    (\p.
       let c = concl p in
       if is_sqequal_term c then
         let (),t2 = dest_sqequal c in
         let sqeq_term_cs =
           map (\op,t,tacs. op, mk_sqequal_term t t2, tacs) cs  in
         (ExecuteComputeSeq sqeq_term_cs 0 THEN AddHiddenLabel `wf`) p
       else
         let T,(),t2 = dest_equal c in
         let eq_term_cs =
           map (\op,t,tacs. op, mk_equal_term T t t2, tacs) cs  in
         (ExecuteComputeSeq eq_term_cs 0 THEN AddHiddenLabel `wf`) p
    )
;;

let form_identity_comp_seq_just t =
  form_comp_seq_just [NOP, t, [] : tactic list]
;;




