%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%
%[
****************************************************************************
****************************************************************************
LOAD-ML.ML
****************************************************************************
****************************************************************************
Load file for nuprl v5 ml files.
]%


% tactics.ml defines mlfiles %
let standard_tactics_relative_path = ["refiners"; "nuprl5"; "tactics"; "standard"];;
let tactic_system =
  let preeq_files, posteq_files =
    (let pre, post = split ((position "equality-tactics" tactic_files) - 1) tactic_files
     in pre, (tl post))

  in
   [ (["refiners"; "nuprl5"; "src"], ["refm-lib"])
   ; (standard_tactics_relative_path, preeq_files)
   ; (standard_tactics_relative_path, ["equality-tactics"])
   ; (standard_tactics_relative_path, posteq_files)
   ; (standard_tactics_relative_path, refiner_files)
   ]
;;

let loadf_nuprl_system = loadf_system [];;

%
%

let load_standard_tactics (():unit) =
    loadf_nuprl_system [(standard_tactics_relative_path, ["tactics"; "load-tac"])]
  ; loadf_nuprl_system tactic_system
;;

let compile_standard_tactics (():unit) =
    loadf_nuprl_system  [(standard_tactics_relative_path, ["tactics"; "load-tac"])]
  ; loadf_nuprl_system  [ (["library"; "top"], ["comm-lib"]) ]
  ; loadf_nuprl_system  [ (["refiners"; "nuprl5"; "src"], ["refm-lib"]) ]
  ; loadft_system [] tactic_system
;;
					  

let cmt n = loadt_system [] [(standard_tactics_relative_path, [n])]
;;
