
ml_curried_infix `THEN_OnEach\'` ;;
ml_curried_infix `THEN\'` ;;

let proof_position p pl =
  search_list (equal_sequents p) pl
;;

letrec remove_dups pl =
  if null pl then (nil,nil)
  else let pp,f = remove_dups (tl pl) in
       let p = hd pl in
       let i = proof_position p pp ? 0 in
       if i = 0 then (p.pp, 1.(map (\j. j + 1) f))
       else (pp, i.f)
;;

let replicate' f l =
  map (\i. nth i l) f
;;

% The following function should be the identity function on lists.
%
let test_dups l =
   let l',f = remove_dups l in
   replicate' f l'
;;

let $THEN_OnEach' (T: tactic) (F : proof list -> tactic list) (p:proof) =

  let pl,v = T p  in
  let pl',f = remove_dups pl in
  let Ts = F pl' in
  if not length Ts = length pl' then
    failwith `THEN_OnEach\': Wrong number of tactics`
  else
  let pll,vl = unzip (map2 ap Ts pl')
  in

    flatten pll,  (\l.v (replicate' f (mapshape (map length pll) vl l)))
;;

let $THEN' T1 T2 = T1 THEN_OnEach' (\ps.replicate T2 (length ps)) ;;


