%
Support for quotient types
%


%
Squashing concl with hyps.

 Hs, Hi1 ... Hin  |- C

     BY CSquashWithHyps hs  

     Hs |- Sq(Hi1 => ...Hin => C)

Assume concl is trivially squash stable (as recognized by TrivializeConcl).


%

let CSquashWithHyps hs p = 
   let new_concl = mk_squash_term
     (mk_iterated_implies (map (\i.h i p) hs @ [concl p]))
   in
   ( Assert new_concl THEN IfLabL 
     [`main`,
     % Sq(Hi1 => ...Hin => C) |- C %
      SquashHD (-1)
      THENM TrivializeConcl
      THENM (RepeatMFor (length hs) (D (-1)) THEN Trivial)
     ;`assertion`,
      OnHyps (rev hs) Thin THENM AddHiddenLabel `main`
     ]
   ) p
;;

%
H,#j: u: x,y:A//E(x,y), J(u) >> s(u) = t(u) in T(u)
  
  BY quotientElimination_2 j $i v w z

  ...   J(u), v:A, w:A >> E(v,w) = E(v,w) in U$i
  ...   J(u), >> T(u) = T(u) in U$i
  ...   v:A, w:A, z:E(v,w) J(v) >> s(v) = s(w) in T(v)

Rule should be really changed to allow one to supply separate universe
level expressions for T and E.
%

let QuotientHD' vars i p =

  let conclT,(),() = dest_equal (concl p) in  
  let i' = get_pos_hyp_num i p in
  let u,T = dest_hyp i' p in
  let x,y,A,Exy = dest_quotient T in
  let [v;w;z] = new_var_set 
                 [[first vars ; u]
                 ;[second vars ; u]
                 ;[]
                 ]
                 (declared_vars p)
  in
  let p' = extend_sequent p [v,A;w,A] in
  let Evw = subst [x,mk_var_term v;y,mk_var_term w] Exy in
                
  ( Refine `quotientElimination_2`  
      (mk_int_arg i'
      . infer_level_exp_arg p' (mk_and_term conclT Exy)
      . map mk_var_arg [v;w;z]
      )
    THENL
    [WFPrettyUp
    ;WFPrettyUp
    ;Id
    ]
  ) p
;;

% Uses better quotientElimination_2 rule %

let QuotDAux i p =
  if i = 0 then failwith `QuotD` else
  let i' = get_pos_hyp_num i p in
  let quotid = analyze_ab_quot_type (h i' p) in
  let vs = [get_optional_var_arg `v1` p; get_optional_var_arg `v2` p] in
  let ThinTac = KeepingAnnotation (Try (Thin i')) in
  let AbThinTac p = KeepingAnnotation (Thin i' ORELSE FoldTop quotid i') p in
  if quotid = `quotient` then
   (QuotientHD' vs i' THEN ThinTac) p
  else
   ( UnfoldTopAb i'
     THEN QuotientHD' vs i'
     THEN AbThinTac
   ) p
;;

% 
Expand options for concl to member and squash terms.
%

let QuotD i p =
  let c = concl p in 
  if is_term `equal` c then
     QuotDAux i p 
  if is_term `member` c then
    (UnfoldTop `member` 0 
     THENM QuotDAux i) p
  if is_term `squash` c then
    (UseEqWitness axiom_term
     THENM QuotDAux i
     THENM SquashEqTypeCD
    ) p
  else
    failwith `QuotD: concl must be equal, member or squash`
;;
