
let ref_add_visible_statements_aux index edges data =

  % for each visible_statement env make similar cache %
  declare_refl_cache index;
  declare_nonrefl_cache index;

  declare_inc_cache index;
  declare_qinc_cache index;

  declare_inversion_cache index;
  declare_weakening_cache index;
  declare_functionality_cache index;
  declare_transitivity_cache index;

  % eagerly add Decidadable__ et al? %
  %let edges = get_ref_environment_edges index % % a little kludgey %  %in%
  let decidable__lemmas = toks_with_prefix "decidable__" (map maybe_name_of_lemma data) in
    if not (null decidable__lemmas)
       then ref_add_Decidable__lemmas_assoc index edges decidable__lemmas;
  let sq_stable__lemmas = toks_with_prefix "sq_stable__" 
                          (filter (\x. not (x = `sq_stable__from_stable`))
                                  (map maybe_name_of_lemma data)) in
   if not (null sq_stable__lemmas) then ref_add_sq_stable__lemmas_assoc index edges sq_stable__lemmas;

  visible_statements_ref_state :=
    declare_ref_state_data_indirect `visible_statements` visible_statements_ref_state index data edges

 ; ()    
;;

let ref_add_visible_statements index =
  declare_ref_state_index index `visible_statements` index;
  ref_add_visible_statements_aux index
;;

let ref_set_visible_statements stms index =

  % for each visible_statement env make similar cache %
  declare_refl_cache index;
  declare_nonrefl_cache index;

  declare_inc_cache index;
  declare_qinc_cache index;

  declare_inversion_cache index;
  declare_weakening_cache index;
  declare_functionality_cache index;
  declare_transitivity_cache index;

  declare_ref_state_index index `visible_statements` index;
  visible_statements_ref_state := ref_state_set visible_statements_ref_state index stms;

  ref_add_Decidable__lemmas_assoc index nil
         (toks_with_prefix "decidable__" (map maybe_name_of_lemma stms));

  ref_add_sq_stable__lemmas_assoc index nil
          (toks_with_prefix "sq_stable__" 
                                (filter (\x. not (x = `sq_stable__from_stable`))
                                        (map maybe_name_of_lemma stms)));
 ()    
;;

map (uncurry add_ref_environment_undeclare_hook)
[(`basic`, \index.
 (((visible_statements_ref_state := ref_state_remove visible_statements_ref_state index; ()) ? ());
  ((visible_abstractions_ref_state := ref_state_remove visible_abstractions_ref_state index; ()) ? ());
  ((sq_stable__lemmas_assoc := ref_state_remove sq_stable__lemmas_assoc index; ()) ? ());
  ((Decidable__lemmas_assoc := ref_state_remove Decidable__lemmas_assoc index; ()) ? ())))

;`inc`, undeclare_inc_cache
;`qinc`, undeclare_qinc_cache

;`inversion`, undeclare_inversion_cache
;`weakening`,  undeclare_weakening_cache
;`functionality`, undeclare_functionality_cache
;`transitivity`, undeclare_transitivity_cache

 %declare_refl_cache index;
  declare_nonrefl_cache index;%
;(`refl`,\index. ((ReflEqCD_cache := ref_state_remove ReflEqCD_cache index; () ? ());
                  (NonReflEqCD_cache := ref_state_remove NonReflEqCD_cache index; () ? ())))

 % probably could look at refenv and only try remove those which use index as index.%
 % this list is analogous to reference_environment_update_hooks %
;`RecUnfoldFold`, undeclare_RecUnfoldFold
;`RecEta`, undeclare_RecEta
;`ForceReduce`, undeclare_ForceReduce
;`D_additions`, undeclare_D_additions
;`Trivial_additions`, undeclare_Trivial_additions
;`type_inf`, undeclare_type_inf
;`soft_abstractions`, undeclare_soft_abstractions
;`set_inc`, undeclare_set_inc
;`sub_env`, undeclare_sub_env
;`rrrs_assoc`, undeclare_rrrs_assoc
;`order_rel_family`, undeclare_order_rel_family
;`lin_order_check_fun`, undeclare_lin_order_check_fun
;`arith_property_inf`, undeclare_arith_property_inf
;`simplelist`, undeclare_or_simplelist
; `nml_code`, undeclare_nml_code
; `pattern_list`, undeclare_pattern_list
; `hol_compatible`, undeclare_hol_compatible
]
;;

let ref_state_merge_build name addf =
 (\index edges.
    (%view_showw (`ref_state_merge ` ^ name) (ioids_term (index . (resolve_edges name edges)));%
    addf index (resolve_edges name edges) nil
    ; true)
    ? (%view_showw `ref_state_merge` (ioids_term (index . (resolve_edges name edges)));% false))
;;

update_ref_state_merge `soft_abstractions`
 (ref_state_merge_build  `soft_abstractions` ref_add_soft_abs_aux)
;;

update_ref_state_merge `ForceReduce_alist`
 (ref_state_merge_build `ForceReduce_alist` ref_add_ForceReduce_alist_aux)
;;

update_ref_state_merge `order_rel_families_assoc`
 (ref_state_merge_build  `order_rel_families_assoc` ref_add_order_rel_families_assoc_aux)
;;

update_ref_state_merge `sub_env`
 (ref_state_merge_build  `sub_env` ref_add_sub_env_aux)
;;

update_ref_state_merge `set_inc_alist`
 (ref_state_merge_build  `set_inc_alist` ref_add_set_inc_aux)
;;

update_ref_state_merge `rrrs_assoc`
 (ref_state_merge_build  `rrrs_assoc` ref_add_rrrs_assoc_aux)
;;

update_ref_state_merge `arith_property_inf`
 (ref_state_merge_build  `arith_property_inf` ref_add_arith_property_inf_aux)
;;

update_ref_state_merge `sq_stable__lemmas_assoc`
 (ref_state_merge_build `sq_stable__lemmas_assoc` ref_add_sq_stable__lemmas_assoc_aux)
;;

update_ref_state_merge `Decidable__lemmas_assoc`
 (ref_state_merge_build `Decidable__lemmas_assoc` ref_add_Decidable__lemmas_assoc_aux)
;;

update_ref_state_merge `RecUnfoldFold_alist`
 (ref_state_merge_build `RecUnfoldFold_alist` ref_add_RecUnfoldFold_alist_aux)
;;

update_ref_state_merge `RecEta_alist`
 (ref_state_merge_build `RecEta_alist` ref_add_RecEta_alist_aux)
;;

update_ref_state_merge `Trivial_additions_assoc`
 (ref_state_merge_build `Trivial_additions_assoc` ref_add_Trivial_additions_aux)
;;

update_ref_state_merge `pattern_list`
 (ref_state_merge_build `pattern_list` pattern_list_merge)
;;


let with_refl_caches_reversed t p =
 ( reverse_refl_caches := true;
   let r = t p in
     reverse_refl_caches := false;
     r
 ) ? 
 ( reverse_refl_caches := false
 ; raise_error [] ``with_refl_caches_reversed`` [failure_message ()]
 ; fail )
;;


%
;;;;	
;;;;	reference to code of object with reference_environment tag
;;;;	must be consistent. Ie 
;;;;	to avoid requiring tagging all code FTTB, only references to tagged
;;;;	code need be tagged. Tagging errors do not prevent compilation
;;;;	but are detectable statically after compilation.
;;;;	
;;;;	find object defining id then find ref env tag of object.
;;;;	or require declaration of id and tagging object.
;;;;	  - then in order to legally use an id the re tag must be 
;;;;	    mentioned in environment
;;;;	
;;;;	
;;;;	
;;;;	Need:
;;;;	  
;;;;	Method to validate references to objects through code.
;;;;	  - require code refererencing objects to tagged with reference_environment
;;;;	  - require code referencing tagged code to be tagged.
;;;;	  - code is tagged when object defining code is tagged.
;;;;	    * primitve code can be declared to be in some static object which is then tagged.
;;;;	
;;;;	
;;;;	Some primitive code is dependent on some core_2 abstractions.
;;;;	 - letref to define degenerate version.
;;;;	 - code in core2 sets global to appropriate def in scope of ref env including needed abs.
;;;;	 desire later any ref to letref require core2 code.
;;;;	   * declare letref to be defined in core2 code 
;;;;

letref code_ref_state =
  new_list_ref_state `code`
    (nil : tok list)
;;
%
% if update_hooks modified then  ref_env_remove should be too. %
letref reference_environment_update_hooks =
 [ `RecUnfoldFold_alist`, RecUnfoldFold_do_updates
 ; `RecEta_alist`, RecEta_do_updates
 ; `ForceReduce_alist`, ForceReduce_additions_do_updates
 ; `D_additions_assoc`, D_additions_do_updates
 ; `Trivial_additions_assoc`, Trivial_additions_do_updates
 ; `type_inf`, type_inf_do_updates
 ; `soft_abstractions`, soft_abstractions_do_updates
 ; `set_inc_alist`, set_inc_do_updates
 ; `sub_env`, sub_env_do_updates
 ; `order_rel_families_assoc`, order_rel_family_do_updates
 ; `rrrs_assoc`, rrrs_assoc_do_updates
 ; `lin_order_check_funs_assoc`, lin_order_check_fun_do_updates
 ; `arith_property_inf`, arith_property_inf_do_updates
 ; `simplelist`, simplelist_do_updates
 ; `nml_code`, nml_code_do_updates
 ; `pattern_list`, pattern_list_do_updates
 ; `hol_compatible`, hol_compatible_do_updates
 ; `compseq`, compseq_do_updates
 ]
;;

let reset_reference_environment_update_hooks () =
  map (uncurry set_ref_environment_update_hook)
      reference_environment_update_hooks
;;

let add_reference_environment_update_hook tag hook =
  (reference_environment_update_hooks :=
    update_alist reference_environment_update_hooks tag hook)
   ; reset_reference_environment_update_hooks () 
;;

% recompiling loses hooks added by objects !? %    
reset_reference_environment_update_hooks ();;


%  init_reference_environment_update_hooks ();;
%

letref tree_check_subst_bound = 100000;;
letref rrtcaa_tac = ivoid_term;;

let ref_refine_tree_check_aux_aux makef name envterm igoal tttt =
 %(really_break `rrtcaappp`);%
with_make_ref_environment makef envterm
(\envthing.
 ibool_term
  let reff tgoal ttac contf =
  rrtcaa_tac := ttac;
  (let iinf_tree =
      %with_substitution_count_bound tree_check_subst_bound%
        ((ref_refinet_aux name tgoal ttac) envthing) in
    let subgoals = subgoals_of_iinf_tree iinf_tree in
     % following was allowing smaller trees than original
       not necessarily bad but callers want same tree%
     %if null subgoals then true 
     else %
     tty_print ("rrtcaa " J (int_to_string (length subgoals)));
     let r = contf subgoals in
           if isr r then (all id (outr r))
           else (%really_break `rrtcaa`;%
                  false)
  ) in 
     reset_proof_cache (); %(really_break `rrtcaap`);%
     with_object_id 
      (\ (). (let b = apply_ttt_aux_cont reff (tttt_to_ttt tttt) igoal
	      in b)
	     ? false)
      (new_dummy_object_id ())    % used to provide an obid for proof cache to use in assoc list. %
      )
;;
let set_collect_primitive_references b =
 set_primitive_references b;
 wf_cache_p := true;
 ()
;;


let ref_refine_tree_aux_aux_aux apply_ttt_aux_cont_f makef failp envterm igoal tttt =
 with_make_ref_environment makef envterm
(\envthing.
 let reff tgoal ttac contf =
  tty_print "rrt rrvb";
  let failed,iinf_tree = 
       (if failp
           then (with_error_hook (\e. true,(refine_tree_failt envthing tgoal ttac e))
				 (\x. false, if ivoid_term_p ttac then failwith `no tactic`
                                             else (ref_refinet_aux `refine_tree` tgoal ttac envthing))
				 nil)
           else (false, (ref_refinet_aux `refine_tree` tgoal ttac envthing)) ) in

  tty_print "rrt rrva"; rrtbug := iinf_tree;

  let subgoals = if failed then nil
                 else subgoals_of_iinf_tree iinf_tree in

    tty_print ( "rrt rrvd " J (int_to_string (length subgoals)) J " "
			    J (if failed then "f" else "t"));

    if null subgoals then icons_term iinf_tree inil_term
    else (rrtbug := hd subgoals;
    let r = contf subgoals in
     if isr r then icons_term iinf_tree (map_to_ilist id icons_op (outr r))
     else 
       ( tty_print "rrt ttt"
       ; if not failp then fail
	  else icons_term iinf_tree (map_to_ilist id icons_op subgoals)
       ))
     
    in

    reset_proof_cache ();
    with_object_id 
      (\(). set_collect_primitive_references true;
             let r = if failp
                       then (apply_ttt_aux_cont_f reff (tttt_to_ttt tttt) igoal)
                       else (apply_ttt_aux_cont_f reff (tttt_to_ttt tttt) igoal ? ivoid_term)
	      in (set_collect_primitive_references false; r))
      (new_dummy_object_id ())  % used to provide an obid for proof cache to use in assoc list. %
 
     )
;;


%let ref_refine_tree_check envoid = ref_refine_tree_check_aux `tree_check` (ioid_term envoid);;
%
let ref_refine_tree_aux_aux = ref_refine_tree_aux_aux_aux apply_ttt_aux_cont;;
	      
let ref_refine_tree_wg_aux_aux = ref_refine_tree_aux_aux_aux apply_ttt_aux_cont_wg;;

