#!/usr/bin/python -W ignore

from xml.dom import minidom                                          

import sys
import string
import re



xmldoc = minidom.parse(sys.argv[1])


species = {}
for x in xmldoc.getElementsByTagName('variables'):
	for k in x.childNodes:
		if k.localName!= None:
			if (k.hasAttribute('name')):
				print "species(" + k.getAttribute("name").lower() + ")."
				species[k.getAttribute("name").lower()] = 0
				if (k.hasAttribute('bound')):
					print "capacity(" + k.getAttribute("name").lower() + ","+k.getAttribute("bound")+")."
				else:
					print "capacity(" + k.getAttribute("name").lower() + ",1)."
					

expCounter = 0
for x in xmldoc.getElementsByTagName('experiments'):
	for state in x.getElementsByTagName('x'):
		statename=""
		if (state.hasAttribute('nr')):
			statename = "s"+state.getAttribute("nr").lower()
			print "state(" + statename + ")."
		if (state.hasAttribute('nval')):
			statevector = state.getAttribute("nval")
			statevector = statevector.lower().split(' ')
			statemap = species.copy()
			for i in statevector:
				if i != '':
					statemap[i]+=1
			for i in statemap.keys():
				print "value("+str(statename)+","+ str(i) +","+str(statemap[i])+")."
		if (state.hasAttribute('attr')):
			if (state.getAttribute("attr") == "final"):
				print "terminalState("+statename+")."


	for transition in x.getElementsByTagName('r'):
		fr = ""
		to = ""
		if (transition.hasAttribute('fr')):
			fr = "s"+transition.getAttribute('fr').lower()
		if (transition.hasAttribute('to')):
			to = "s"+transition.getAttribute('to').lower()
		print "response(" + fr + ","+ to + ")."
		
	for pertubation in x.getElementsByTagName('p'):
		fr = ""
		to = ""
		if (pertubation.hasAttribute('fr')):
			fr = "s"+pertubation.getAttribute('fr').lower()
		if (pertubation.hasAttribute('to')):
			to = "s"+pertubation.getAttribute('to').lower()
		print "pertubation(" + fr + ","+ to + ")."
			 

