
% Domain: satellite
#base.
% 
% 
% EFFECTS: ADD  >>>>>
adds( switch_off( I,S ),power_avail( S ) ) :- holds( on_board( I,S ) ).
adds( calibrate( S,I,D ),calibrated( I ) ) :- holds( on_board( I,S ) ), holds( calibration_target( I,D ) ).
adds( take_image( S,D,I,M ),have_image( D,M ) ) :- holds( on_board( I,S ) ), holds( supports( I,M ) ), typedobject( direction( D ) ).
adds( turn_to( S,Dnew,Dprev ),pointing( S,Dnew ) ) :- typedobject( satellite( S ) ), typedobject( direction( Dnew ) ), typedobject( direction( Dprev ) ).
adds( switch_on( I,S ),power_on( I ) ) :- holds( on_board( I,S ) ).
% <<<<<  EFFECTS: ADD
% 

% 
% 
% EFFECTS: DEL  >>>>>
deletes( switch_off( I,S ),power_on( I ) ) :- holds( on_board( I,S ) ).
deletes( turn_to( S,Dnew,Dprev ),pointing( S,Dprev ) ) :- typedobject( satellite( S ) ), typedobject( direction( Dnew ) ), typedobject( direction( Dprev ) ).
deletes( switch_on( I,S ),calibrated( I ) ) :- holds( on_board( I,S ) ).
deletes( switch_on( I,S ),power_avail( S ) ) :- holds( on_board( I,S ) ).
% <<<<<  EFFECTS: DEL
% 

% 
% 
% TYPES  >>>>>
object( X ) :- typedobject( instrument( X ) ).
object( X ) :- typedobject( satellite( X ) ).
object( X ) :- typedobject( direction( X ) ).
object( X ) :- typedobject( mode( X ) ).
% <<<<<  TYPES
% 

% 
% 
% REIFIED ENCODING OF DOMAIN ACTIONS  >>>>>
action( switch_off( I,S ) ) :- holds( on_board( I,S ) ).
action( calibrate( S,I,D ) ) :- holds( on_board( I,S ) ), holds( calibration_target( I,D ) ).
action( take_image( S,D,I,M ) ) :- holds( on_board( I,S ) ), holds( supports( I,M ) ), typedobject( direction( D ) ).
action( turn_to( S,Dnew,Dprev ) ) :- typedobject( satellite( S ) ), typedobject( direction( Dnew ) ), typedobject( direction( Dprev ) ).
action( switch_on( I,S ) ) :- holds( on_board( I,S ) ).
% <<<<<  REIFIED ENCODING OF DOMAIN ACTIONS
% 

% 
% 
% REIFIED ENCODING OF PRECONDITIONS  >>>>>
demands( switch_off( I,S ),power_on( I ),true ) :- holds( on_board( I,S ) ).
demands( calibrate( S,I,D ),pointing( S,D ),true ) :- holds( on_board( I,S ) ), holds( calibration_target( I,D ) ).
demands( calibrate( S,I,D ),power_on( I ),true ) :- holds( on_board( I,S ) ), holds( calibration_target( I,D ) ).
demands( take_image( S,D,I,M ),calibrated( I ),true ) :- holds( on_board( I,S ) ), holds( supports( I,M ) ), typedobject( direction( D ) ).
demands( take_image( S,D,I,M ),power_on( I ),true ) :- holds( on_board( I,S ) ), holds( supports( I,M ) ), typedobject( direction( D ) ).
demands( take_image( S,D,I,M ),pointing( S,D ),true ) :- holds( on_board( I,S ) ), holds( supports( I,M ) ), typedobject( direction( D ) ).
demands( take_image( S,D,I,M ),power_on( I ),true ) :- holds( on_board( I,S ) ), holds( supports( I,M ) ), typedobject( direction( D ) ).
demands( turn_to( S,Dnew,Dprev ),pointing( S,Dprev ),true ) :- typedobject( satellite( S ) ), typedobject( direction( Dnew ) ), typedobject( direction( Dprev ) ).
demands( switch_on( I,S ),power_avail( S ),true ) :- holds( on_board( I,S ) ).
% <<<<<  REIFIED ENCODING OF PRECONDITIONS
% 

