/***************************************************************************
                          typedefinitions  -  description
                             -------------------
    begin                : Sun Jan 9 2005
    copyright            : (C) 2005 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef TYPEDEFINITIONS_H
#define TYPEDEFINITIONS_H

#include <set>
#include <algorithm>
#include <functional>
#include "misc.h"

namespace NS_NOMORE {

class CBodyNode;
class CHeadNode;
class CNode;

//! Comparison between to pointer objects via GetId()
template <class T>
struct CLessIdDeref : public std::binary_function<T*, T*, bool> {
  bool operator()(const T* lhs, const T* rhs) {
    return lhs->GetId() < rhs->GetId();
  }
};

//! Comparison between to pointer objects via comparison operator
template <class T>
struct CLessDeref : public std::binary_function<T*, T*, bool> {
  bool operator()(const T* lhs, const T* rhs) {
    return std::less<T>()(*lhs, *rhs);
  }
};

//! Deleting pointers using foreach methode of stl.
struct DerefDelete {
  template <class T>
  void operator()(T* p) const {
    delete p;
  }
};

//! Set of head nodes sorted by id.
typedef std::set<CHeadNode*, CLessIdDeref<CNode> > THeadNodeSet;
typedef THeadNodeSet::const_iterator THeadNodeSetIterator;

//! Sequence of head nodes.
typedef std::vector<CHeadNode*> THeadNodeVector;
typedef THeadNodeVector::const_iterator THeadNodeVectorIterator;

//! Set of body nodes sorted by id.
typedef std::set<CBodyNode*, CLessIdDeref<CNode> > TBodyNodeSet;
typedef TBodyNodeSet::const_iterator TBodyNodeSetIterator;

//! Sequence of body nodes.
typedef std::vector<CBodyNode*> TBodyNodeVector;
typedef TBodyNodeVector::const_iterator TBodyNodeVectorIterator;

//! Enumerations of several nodes.
typedef enum {
  type_cbodynode,
  type_cheadnode
} TNodeType;

//! Set of ids to atoms.
typedef std::set<TId> TIdSet;
typedef TIdSet::const_iterator TIdSetIterator;

//! Sequence of atoms.
typedef std::vector<CAtom*> TAtomVector;
typedef TAtomVector::iterator TAtomVectorIterator;

//! Set of bodies sorted by id.
typedef std::set<CBody*, CLessDeref<CBody> > TnBodySet;
typedef TnBodySet::iterator TnBodySetIterator;

//! Sequence of rules.
typedef std::vector<CRule*> TRuleVector;
typedef TRuleVector::const_iterator TRuleVectorIterator;

//! Queue only for bodynodes.
typedef std::queue<CBodyNode*> TBodyNodeQueue;

} // NS_NOMORE

#endif
