/***************************************************************************
                          coperator.cpp  -  description
                             -------------------
    begin                : Tue Jul 29 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <stdio.h>
#include "caggregation.h"
#include "coperator.h"
#include "cnode.h"
#include "print.h"
#include "misc.h"
#include "algorithm.h"
#include "io.h"
#include "cheuristic.h"
#include "ctodo.h"

namespace NS_NOMORE{

bool tmpf_RestoreGraph(CGraph* graph, CStack* stack, CTodoLists *todo, bool restore_cps) {
	CHECK_POINTER("COperatorDQ::RestoreGraph(graph)", graph);
	CHECK_POINTER("COperatorDQ::RestoreGraph(stack)", stack);
	CHECK_POINTER("COperatorDQ::RestoreGraph(todo)" , todo);

  while(true) {

    if(stack->empty())
      return false;

    TStackElement top = stack->top();
    if(top._ChoicePoint && top._ChoicePointColor != color_none)
        return true;

    graph->SetCanBePropagated(top._pNode->GetId(), top._pNode->GetType(), top._pNode->GetColor(), false);
    
    graph->LoadState(&top, stack, todo);
    if(restore_cps && top._pNode->GetType() == type_cbodynode) {
      todo->PushPossChoices(top._pNode);
      todo->PushCPossChoices(top._pNode);
      INC_COUNT(queue_cp_call);
    }

    stack->pop();
  }
  
  return true;
}

bool tmpf_RestoreGraph2(CGraph* graph, CStack* stack, CTodoLists *todo, bool restore_cps) {
	CHECK_POINTER("COperatorDQ::RestoreGraph(graph)", graph);
	CHECK_POINTER("COperatorDQ::RestoreGraph(stack)", stack);
	CHECK_POINTER("COperatorDQ::RestoreGraph(todo)" , todo);

  while(true) {

    if(stack->empty())
      return false;

    TStackElement top = stack->top();
    if(top._ChoicePoint && top._ChoicePointColor != color_none)
        return true;

    graph->LoadState(&top, stack, todo);
//    graph->SetCanBePropagated(top._pNode->GetId(), top._pNode->GetType(), false);
    if(restore_cps && top._pNode->GetType() == type_cbodynode) {
      todo->PushPossChoices(top._pNode);
      todo->PushCPossChoices(top._pNode);
      INC_COUNT(queue_cp_call);
    }

    stack->pop();
  }
  return true;
}


string ReturnValue(TRetOperator val) {
  switch(val) {
    case return_unchanged:
      return string("unchanged");
    case return_changed:
      return string("changed");
    case return_colorerror:
      return string("error");
    default:
      return string("unknown");
  }
}

string bool2str(bool val) {
  if(val)
    return string("true");
  else
    return string("false");
}

/***************************************************************************
 *                                                                         *
 * main operator descriptions                                              *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
  class COperator
****************************************************************************/
bool COperator::_use_simple_choice_operator = false;
COperator::COperator() {
  
  CREATEOBJECT("COperator");
  
}

COperator::~COperator() {
  
  DELETEOBJECT("COperator");
  
}

bool COperator::operator==(COperator& op) {
  
	return GetType() == op.GetType();
  
}

bool COperator::operator!=(COperator& op) {
  
	return GetType() != op.GetType();
  
}

/***************************************************************************
  class CDetOperator
****************************************************************************/
CDetOperator::CDetOperator() : COperator() {
  
  CREATEOBJECT("CDetOperator");
  
}

CDetOperator::~CDetOperator() {
  
  DELETEOBJECT("CDetOperator");
  
}

/***************************************************************************
  class CDetOperatorNone
****************************************************************************/
CDetOperatorNone::CDetOperatorNone() : CDetOperator() {
  
  CREATEOBJECT("CDetOperatorNone");
  
}

CDetOperatorNone::~CDetOperatorNone() {
  
  DELETEOBJECT("CDetOperatorNone");
  
}

TRetOperator CDetOperatorNone::Call(CGraph* graph,
                                    CStack* stack,
                                    CTodoLists *todo,
                                    CStatusInformation* status) {

  CHECK_POINTER("CDetOperatorNone::Call(graph)", graph);
  CHECK_POINTER("CDetOperatorNone::Call(stack)", stack);
  CHECK_POINTER("CDetOperatorNone::Call(todo)" , todo);

  INC_COUNT(methode_operator_none_call);
  
  return return_unchanged;
  
}

/***************************************************************************
 *                                                                         *
 * call operator descriptions                                              *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
  COperatorBP
****************************************************************************/
COperatorBP::COperatorBP() : CDetOperator() {
  
  CREATEOBJECT("COperatorBP");
  
}

COperatorBP::~COperatorBP() {
  
  DELETEOBJECT("COperatorBP");
  
}

TRetOperator COperatorBP::Call(CGraph* graph, CStack* stack, CTodoLists *todo,
                CStatusInformation* status) {
  
  CHECK_POINTER("COperatorBP::Call(graph)", graph);
  CHECK_POINTER("COperatorBP::Call(stack)", stack);
  CHECK_POINTER("COperatorBP::Call(todo)" , todo);

  INC_COUNT(methode_operator_bp_call);

  TRetOperator val = return_unchanged;
  TRetOperator v = return_unchanged;

  while(!todo->EmptyBackProp()) {
    CNode* node = todo->PopBackProp();

    if(node->GetColor() != color_none && node->GetColor() != color_ignore) {
      if(node->GetType() == type_cheadnode)
        v = BackPropHeadNode(graph, stack, (CHeadNode*)node, todo, status);
      else
        v = BackPropBodyNode(graph, stack, (CBodyNode*)node, todo, status);
    
      if(v == return_changed)
        val = v;
      else
      if(v == return_colorerror)
        return v;
    }
  }

  return val;  
}

TRetOperator COperatorBP::BackPropHeadNode(CGraph* graph, CStack* stack, CHeadNode *node,
                CTodoLists *todo, CStatusInformation* status) {
  
  CHECK_POINTER("COperatorBP::BackPropHeadNode(graph)", graph);
  CHECK_POINTER("COperatorBP::BackPropHeadNode(stack)", stack);
  CHECK_POINTER("COperatorBP::BackPropHeadNode(node)" , node);
  CHECK_POINTER("COperatorBP::BackPropHeadNode(todo)" , todo);

  TRetOperator val = return_unchanged;

  // head node is (weak) plus
  if(node->GetColor() == color_plus || node->GetColor() == color_weak_plus) {
    
    // only one predecessor is not colored plus
    if(node->UnsupportedCounter() == 1) {
      // find uncolored predecessor
      TBodyNodeSetIterator ite = node->GetPredecessors().begin();
      TBodyNodeSetIterator end = node->GetPredecessors().end();
      for(; ite!=end; ite++) {
        CBodyNode* n = *ite;
        if(n->GetColor() == color_none || n->GetColor() == color_ignore) {
          if(graph->ColorNode(n, color_weak_plus, stack, false, color_none, todo, status)) {
            todo->PushBackProp(n);
            todo->PushProp(n);
            return return_changed;
          } else {
            return return_colorerror;
          } // if (colornode)
        } // if (uncolored/ignore)
      } // for
    } // if (unsupported-counter)
  } else
  // head node is minus
  if(node->GetColor() == color_minus) {
    // color all predecessors minus
    TBodyNodeSetIterator ite = node->GetPredecessors().begin();
    TBodyNodeSetIterator end = node->GetPredecessors().end();
    for(; ite!=end; ite++) {
      CBodyNode* n = *ite;
      if(n->GetColor() == color_none || n->GetColor() == color_ignore) {
        if(graph->ColorNode(n, color_minus, stack, false, color_none, todo, status)) {
          todo->PushBackProp(n);
          todo->PushProp(n);
          val = return_changed;
        } else {
          return return_colorerror;
        } // if (colornode)
      } // if (uncolored/ignore)
    } // for
  }
  return val;
}

TRetOperator COperatorBP::BackPropBodyNode(CGraph* graph, CStack* stack, CBodyNode *node,
                CTodoLists *todo, CStatusInformation* status) {

  CHECK_POINTER("COperatorBP::BackPropBodyNode(graph)", graph);
  CHECK_POINTER("COperatorBP::BackPropBodyNode(stack)", stack);
  CHECK_POINTER("COperatorBP::BackPropBodyNode(node)" , node);
  CHECK_POINTER("COperatorBP::BackPropBodyNode(todo)" , todo);

  TRetOperator val = return_unchanged;

  // body node is (weak) plus
  if(node->GetColor() == color_plus || node->GetColor() == color_weak_plus) {
    
    // color 0-predecessors weak plus
    THeadNodeSetIterator ite = node->GetZeroPredecessors().begin();
    THeadNodeSetIterator end = node->GetZeroPredecessors().end();
    
    for(; ite!=end; ite++) {
      CNode* n = *ite;
      if(n->GetColor() != color_none)
        continue;

      if(!graph->ColorNode(n, color_weak_plus, stack, false, color_none, todo, status)) {
        return return_colorerror;
      }
//      todo->PushProp(n);
      todo->PushBackProp(n);
      val = return_changed;
    }

    // color 1-predecessors minus
    ite = node->GetOnePredecessors().begin();
    end = node->GetOnePredecessors().end();
    for(; ite!=end; ite++) {
      CNode* n = *ite;
      if(n->GetColor() != color_none)
        continue;

      if(!graph->ColorNode(n, color_minus, stack, false, color_none, todo, status)) {
        return return_colorerror;
      }
      todo->PushBackProp(n);
//      todo->PushProp(n);
      val = return_changed;
    }
  
  } else
  // body node is minus and unblocked (-> but not supported)
  if(node->GetColor() == color_minus && node->Unblocked()) {

    // one pred is uncolored -> color minus
    if(node->WeakSupportedCounter() == 1) {

      // find uncolored 0-predecessor
      THeadNodeSetIterator ite = node->GetZeroPredecessors().begin();
      THeadNodeSetIterator end = node->GetZeroPredecessors().end();
      for(; ite!=end; ite++) {
        CNode* n = *ite;
        if(n->GetColor() == color_none) {
          if(graph->ColorNode(n, color_minus, stack, false, color_none, todo, status)) {
            todo->PushBackProp(n);
//            todo->PushProp(n);
            return return_changed;
          } else {
            return return_colorerror;
          } // if (colornode)
        } // if (uncolored)
      } // for
    } // if (weak-support-counter)

  } else
  // body node is minus and (weak) supported (-> but not blocked)
  if(node->GetColor() == color_minus && node->WeakSupported()) {

    // one predecessor is uncolored -> color weak plus
    if(node->UnblockedCounter() == 1) {

      // find 1-predecessor
      THeadNodeSetIterator ite = node->GetOnePredecessors().begin();
      THeadNodeSetIterator end = node->GetOnePredecessors().end();
      for(; ite!=end; ite++) {
        CNode* n = *ite;
        if(n->GetColor() == color_none) {
          if(graph->ColorNode(n, color_weak_plus, stack, false, color_none, todo, status)) {
            todo->PushBackProp(n);
//            todo->PushProp(n);
            return return_changed;
          } else {
            return return_colorerror;
          } // if (colornode)
        } // if (uncolored)
      }  // for
    } // if (unblocked-counter)
    
  }

  return return_unchanged;  
}

/***************************************************************************
  COperatorMS
****************************************************************************/
COperatorMS::COperatorMS() : CDetOperator() {
  
  CREATEOBJECT("COperatorMS");
  
}

COperatorMS::~COperatorMS() {
  
  DELETEOBJECT("COperatorMS");
  
}

TRetOperator COperatorMS::Call(CGraph* graph,
                               CStack* stack,
                               CTodoLists *todo,
                               CStatusInformation* status) {
  
	CHECK_POINTER("COperatorMS::Call(graph)", graph);
	CHECK_POINTER("COperatorMS::Call(stack)", stack);
	CHECK_POINTER("COperatorMS::Call(todo)" , todo);

  INC_COUNT(methode_operator_ms_call);

  TRetOperator val = return_unchanged;

  // while todo list is not empty
	while (!todo->EmptyProp()) {

    // get top node
    CNode *todo_node = todo->PopProp();

    // take next node if this node is minus or a head node
    if(todo_node->GetColor() == color_minus ||
       todo_node->GetType() != type_cbodynode)
      continue;

    CBodyNode *bodynode = (CBodyNode*)todo_node;

    // color plus if supported and uncolored
    if(bodynode->GetColor() != color_plus && bodynode->Supported()) {
      if(!graph->ColorNode(bodynode, color_plus, stack, false,
                           color_none, todo, status)) {

        return return_colorerror;

      } // if (colornode)

      val = return_changed;

    } // if (plus and supp)

  } // while

  return val;

}

/***************************************************************************
  COperatorP
****************************************************************************/
COperatorP::COperatorP() : CDetOperator() {

  CREATEOBJECT("COperatorP");

}

COperatorP::~COperatorP() {

  DELETEOBJECT("COperatorP");

}

TRetOperator COperatorP::Call(CGraph* graph,
                              CStack* stack,
                              CTodoLists *todo,
                              CStatusInformation* status) {

	CHECK_POINTER("COperatorP::Call(graph)", graph);
	CHECK_POINTER("COperatorP::Call(stack)", stack);
	CHECK_POINTER("COperatorP::Call(todo)" , todo);

  INC_COUNT(methode_operator_p_call);

  TRetOperator val = return_unchanged;

  TBodyNodeVector* nodes = graph->GetBodyNodes();
  TBodyNodeVectorIterator ite;

  for(ite=nodes->begin();ite!=nodes->end();ite++) {

    CBodyNode* node = *ite;

    // do not propagate ignore colored nodes
    if(node->GetColor() == color_ignore)
      continue;

    // get unsupported or blocked rules
    if((node->GetColor() != color_minus) &&
       (node->Unsupported() || node->Blocked())) {

      // color node if possible
      if(!graph->ColorNode(node, color_minus, stack, false, color_none,
                           todo, status)) {

        return return_colorerror;

      } // if (colornode)

      val = return_changed;

    } else
    // get supported and unblocked rules
    if(node->GetColor() != color_plus && node->Supported()) {

      if(node->Unblocked()) {

        if(!graph->ColorNode(node, color_plus, stack, false, color_none,
                             todo, status)) {

          return return_colorerror;

        } // if (colornode)

        val = return_changed;

      } else {

        // insert into CP - queue
        todo->PushPossChoices(node);
        INC_COUNT(queue_cp_call);

      } // if (unblocked)

    } // if(!plus and supp)

  } // for

  return val;

}

/***************************************************************************
  COperatorPs
****************************************************************************/
COperatorPs::COperatorPs() : CDetOperator() {

  CREATEOBJECT("COperatorPs");

}

COperatorPs::~COperatorPs() {

  DELETEOBJECT("COperatorPs");

}

TRetOperator COperatorPs::Call(CGraph* graph, CStack* stack, CTodoLists *todo,
                CStatusInformation* status) {

  // check for null pointer
  CHECK_POINTER("COperatorPtodo::Call(graph)", graph);
  CHECK_POINTER("COperatorPtodo::Call(stack)", stack);
  CHECK_POINTER("COperatorPtodo::Call(todo)" , todo);
  // increment counter
  INC_COUNT(methode_operator_ps_call);

  TRetOperator val = return_unchanged;
  
  // while todo list is not empty
  while (!todo->EmptyProp()) {
    // get top node
    CBodyNode *node = todo->PopProp();

    // if node is colored to ignore take the next node if possible
    if(node->GetColor() != color_ignore) {

      // node is (unsupported OR blocked) and not minus
      if((node->GetColor() != color_minus) && (node->Blocked() || node->Unsupported())) {
        // color node if possible        
        if(!graph->ColorNode(node, color_minus, stack, false, color_none, todo, status)) {
          return return_colorerror;
        }

        val = return_changed;
      } else
      // get all (weak) supported nodes
      if(node->WeakSupported()) {
        // get all (supported OR weak-supported) and blocked nodes
        if(node->GetColor() != color_plus && node->Unblocked()) {
          // declare color for color node
          TColor new_color = color_plus;
          // change color if only weak supported
          if(!node->Supported())
            new_color = color_weak_plus;
            
          // try to color node
          if(!graph->ColorNode(node, new_color, stack, false, color_none, todo, status)) {
            return return_colorerror;
          }

          val = return_changed;
        } else
        // if only (supported OR weak-supported) and uncolored put
        // into choice point list
        if(node->GetColor() == color_none) {
          todo->PushPossChoices(node);
          INC_COUNT(queue_cp_call);
        } // unblocked
      } // support
    } // color ignore
  }

  return val;
}

/***************************************************************************
  COperatorLABH
****************************************************************************/
COperatorLABH::COperatorLABH() : CDetOperator() {

  CREATEOBJECT("COperatorLABH");

}

COperatorLABH::~COperatorLABH() {

  DELETEOBJECT("COperatorLABH");

}

TRetOperator COperatorLABH::Call(CGraph* graph, CStack* stack, CTodoLists *todo, CStatusInformation* status) {
  // check for null pointer
	CHECK_POINTER("COperatorLABH::Call(graph)", graph);
	CHECK_POINTER("COperatorLABH::Call(stack)", stack);
	CHECK_POINTER("COperatorLABH::Call(todo)" , todo);

  // increment counter
  INC_COUNT(methode_operator_labh_call);

  TRetOperator val = return_unchanged;

  bool finish = false;
  CNode *next = NULL;
  CNode *last = NULL;
  CTodoLists lookahead_todo;
  CStack lookahead_stack;
  CDetOperator *lookahead_op = NULL;
  CStatusInformation lookahead_status;

  /*********************************************************************************
   * Prepare operator for lookahead tests                                          */
  CAggregationStar     *starPsBP = new CAggregationStar();
  CAggregationStar     *starPsBPV4 = new CAggregationStar();

  CAggregationSequence *seqPsBP  = new CAggregationSequence();
  CAggregationSequence *seqPsBPV4  = new CAggregationSequence();

  COperatorPs *ps = new COperatorPs();
  COperatorBP *bp = new COperatorBP();
  CDetOperator *v4;
  if(COperator::UseSimpleChoiceOperator())
    v4 = new COperatorU();
  else
    v4 = new COperatorV4();

  seqPsBP->SetFirst(ps);
  seqPsBP->SetSecond(bp);
  
  starPsBP->SetOperator(seqPsBP);

  seqPsBPV4->SetFirst(starPsBP);
  seqPsBPV4->SetSecond(v4);

  starPsBPV4->SetOperator(seqPsBPV4);
  
  lookahead_op = starPsBPV4;
  /*********************************************************************************/

//  cout << *todo << endl;
  graph->BeginLookahead();
  
/*  cout << "BEGIN LOOKAHEAD" << endl;
  cout << *graph << endl;
  cout << *todo << endl;
*/
  while(!todo->EmptyCPossChoices() && !finish) {
    next = todo->PopCPossChoices();

    if(next != NULL && next->GetColor() == color_none) {
      if(next != last) {
        if(last == NULL)
          last = next;
          
/*        if(next->GetType() == type_cbodynode)  
          cout << "test-b: " << *(CBodyNode*)next;
        else
          cout << "test-h: " << *(CHeadNode*)next;
  */                     
        if(next->GetType() == type_cbodynode &&
           !graph->GetCanBePropagatedOfBodyPlus(next->GetId(), ((CBodyNode*)next)->Supported())){
          lookahead_status.Clear();  
          graph->SetCanBePropBySupportedNode(((CBodyNode*)next)->Supported());
          
//          cout << "LABH: BodyNode = " << *(CBodyNode*)next;
            
          lookahead_todo.PushBackProp(next);
          lookahead_todo.PushProp((CBodyNode*)next);
          if(!graph->ColorNode(next, color_plus, &lookahead_stack, false, color_none, 
              &lookahead_todo, &lookahead_status) ||
             return_colorerror == lookahead_op->Call(graph, &lookahead_stack, &lookahead_todo, 
              &lookahead_status)) {
              
//            cout << "error b+" << endl;
              
            tmpf_RestoreGraph(graph, &lookahead_stack, &lookahead_todo, false);
            lookahead_todo.ClearPossChoices();
            lookahead_todo.ClearCPossChoices();
            lookahead_todo.ClearProp();
            lookahead_todo.ClearBackProp();
            lookahead_todo.ClearMinus();

            todo->PushBackProp(next);
            todo->PushProp((CBodyNode*)next);
            if(!graph->ColorNode(next, color_minus, stack, false, color_none, todo) ||
               return_colorerror == lookahead_op->Call(graph, stack, todo)) {
                
              delete lookahead_op;
              graph->EndLookahead();
              return return_colorerror;
            }

            last = todo->GetCPossChoicesQueue()->back();
          } else {
            next->SetMaxHeuristics(lookahead_status.GetHardColored());
            lookahead_todo.ClearPossChoices();
            lookahead_todo.ClearCPossChoices();

            tmpf_RestoreGraph2(graph, &lookahead_stack, &lookahead_todo, false);
            todo->PushCPossChoices(next);
          }
        } else
        if(next->GetType() == type_cheadnode &&
           !graph->GetCanBePropagatedOfHeadMinus(next->GetId())) {
          lookahead_status.Clear();     
          graph->SetCanBePropBySupportedNode(false);
          
//          cout << "LABH: HeadNode = " << *(CHeadNode*)next;
          
          lookahead_todo.PushBackProp(next);
          if(!graph->ColorNode(next, color_minus, &lookahead_stack, false, color_none,
              &lookahead_todo, &lookahead_status) ||
             return_colorerror == lookahead_op->Call(graph, &lookahead_stack, &lookahead_todo, 
              &lookahead_status)) {

//            cout << "error h-" << endl;
            
            tmpf_RestoreGraph(graph, &lookahead_stack, &lookahead_todo, false);
            lookahead_todo.ClearPossChoices();
            lookahead_todo.ClearCPossChoices();
            lookahead_todo.ClearProp();
            lookahead_todo.ClearBackProp();
            lookahead_todo.ClearMinus();
 
            todo->PushBackProp(next);
            if(!graph->ColorNode(next, color_weak_plus, stack, false, color_none, todo) ||
               return_colorerror == lookahead_op->Call(graph, stack, todo)) {
                  
              delete lookahead_op;
              graph->EndLookahead();
              return return_colorerror;
            }
 
            last = todo->GetCPossChoicesQueue()->back();
          } else {
            next->SetMaxHeuristics(lookahead_status.GetHardColored());
  
            lookahead_todo.ClearPossChoices();
            lookahead_todo.ClearCPossChoices();
 
            tmpf_RestoreGraph2(graph, &lookahead_stack, &lookahead_todo, false);
            todo->PushCPossChoices(next);
          }
        } else {// which node type and can be propagated
          todo->PushCPossChoices(next);
        }
      } else {
        finish = true;
        todo->PushCPossChoices(next);
      } // if next == last
    } else // if next != NULL and not uncolored
    if(next == last) {
      finish = true;
    }
  }

  delete lookahead_op;
  graph->EndLookahead();
  return val;
}

/***************************************************************************
  COperatorLAB
****************************************************************************/
COperatorLAB::COperatorLAB() : CDetOperator() {

  CREATEOBJECT("COperatorLAB");

}

COperatorLAB::~COperatorLAB() {

  DELETEOBJECT("COperatorLAB");

}

TRetOperator COperatorLAB::Call(CGraph* graph, CStack* stack, CTodoLists *todo, CStatusInformation* status) {
  // check for null pointer
  CHECK_POINTER("COperatorLAB::Call(graph)", graph);
  CHECK_POINTER("COperatorLAB::Call(stack)", stack);
  CHECK_POINTER("COperatorLAB::Call(todo)" , todo);

  // increment counter
  INC_COUNT(methode_operator_labh_call);

  TRetOperator val = return_unchanged;

  bool finish = false;
  CNode *next = NULL;
  CNode *last = NULL;
  CTodoLists lookahead_todo;
  CStack lookahead_stack;
  CDetOperator *lookahead_op = NULL;
  CStatusInformation lookahead_status_plus;
  CStatusInformation lookahead_status_minus;

  /***************************************************************************
   * prepare operator for lookahead tests                                    */
  CAggregationStar     *starPsBP = new CAggregationStar();
  CAggregationStar     *starPsBPV4 = new CAggregationStar();

  CAggregationSequence *seqPsBP  = new CAggregationSequence();
  CAggregationSequence *seqPsBPV4  = new CAggregationSequence();

  COperatorPs *ps = new COperatorPs();
  COperatorBP *bp = new COperatorBP();
  CDetOperator *v4;
  if(COperator::UseSimpleChoiceOperator())
    v4 = new COperatorU();
  else
    v4 = new COperatorV4();

  seqPsBP->SetFirst(ps);
  seqPsBP->SetSecond(bp);
  
  starPsBP->SetOperator(seqPsBP);

  seqPsBPV4->SetFirst(starPsBP);
  seqPsBPV4->SetSecond(v4);

  starPsBPV4->SetOperator(seqPsBPV4);
  
  lookahead_op = starPsBPV4;
  /***************************************************************************/

  graph->BeginLookahead();

  bool error;
  while(!todo->EmptyCPossChoices() && !finish) {
    next = todo->PopCPossChoices();
    
    if(next != NULL && next->GetColor() == color_none) {
      if(next != last) {
        if(last == NULL)
          last = next;
                        
        if(next->GetType() == type_cbodynode) {
          error = false;
          if(!graph->GetCanBePropagatedOfBodyPlus(next->GetId(), ((CBodyNode*)next)->Supported())) {
            lookahead_status_plus.Clear();
            graph->SetCanBePropBySupportedNode(((CBodyNode*)next)->Supported());
            
            lookahead_todo.PushBackProp(next);
            lookahead_todo.PushProp((CBodyNode*)next);
            // if node 'next' cant be propagated by another node
            if(!graph->ColorNode(next, color_plus, &lookahead_stack, false, color_none,
                &lookahead_todo, &lookahead_status_plus) ||
               return_colorerror == lookahead_op->Call(graph, &lookahead_stack,  
                &lookahead_todo, &lookahead_status_plus)) {
              
              // delete all nodes from lookahead-vector
              tmpf_RestoreGraph(graph, &lookahead_stack, &lookahead_todo, false);
              lookahead_todo.ClearPossChoices();
              lookahead_todo.ClearCPossChoices();
              lookahead_todo.ClearProp();
              lookahead_todo.ClearBackProp();
              lookahead_todo.ClearMinus();

              todo->PushBackProp(next);
              todo->PushProp((CBodyNode*)next);
              if(!graph->ColorNode(next, color_minus, stack, false, color_none, todo) ||
                 return_colorerror == lookahead_op->Call(graph, stack, todo)) {
                
                delete lookahead_op;
                graph->EndLookahead();
                return return_colorerror;
              } 
                
              last = todo->GetCPossChoicesQueue()->back();
              error = true;
            } else {
              lookahead_todo.ClearPossChoices();
              lookahead_todo.ClearCPossChoices();

              // do not delete nodes from lookahead-vector
              tmpf_RestoreGraph2(graph, &lookahead_stack, &lookahead_todo, false);
            } // lookahead check for plus
          } // canbeprop-check           
            
          if(!error && !graph->GetCanBePropagatedOfBodyMinus(next->GetId(), ((CBodyNode*)next)->Supported())) {
            lookahead_status_minus.Clear();
               
            lookahead_todo.PushBackProp(next);
            lookahead_todo.PushProp((CBodyNode*)next);
            // if node 'next' cant be propagated by another node and
            // no error occured last check for plus
             if(!graph->ColorNode(next, color_minus, &lookahead_stack, false, color_none,
                 &lookahead_todo, &lookahead_status_minus) ||
                return_colorerror == lookahead_op->Call(graph, &lookahead_stack,
                 &lookahead_todo, &lookahead_status_minus)) {
              
              tmpf_RestoreGraph(graph, &lookahead_stack, &lookahead_todo, false);
              lookahead_todo.ClearPossChoices();
              lookahead_todo.ClearCPossChoices();
              lookahead_todo.ClearProp();
              lookahead_todo.ClearBackProp();
              lookahead_todo.ClearMinus();
                  
              todo->PushBackProp(next);
              todo->PushProp((CBodyNode*)next);
              TColor prop_color = color_weak_plus;
              if(((CBodyNode*)next)->Supported())
                prop_color = color_plus;
                
              if(!graph->ColorNode(next, prop_color, stack, false, color_none, todo) ||
                 return_colorerror == lookahead_op->Call(graph, stack, todo)) {
                
                delete lookahead_op;
                graph->EndLookahead();
                return return_colorerror;
              }
 
              last = todo->GetCPossChoicesQueue()->back();
              error = true;
            } else {
              if(lookahead_status_plus.GetHardColored() > 
                 lookahead_status_minus.GetHardColored()) {
                next->SetMaxHeuristics(lookahead_status_plus.GetHardColored());
                next->SetMinHeuristics(lookahead_status_minus.GetHardColored());
              } else {
                next->SetMinHeuristics(lookahead_status_plus.GetHardColored());
                next->SetMaxHeuristics(lookahead_status_minus.GetHardColored());
              } 

              lookahead_todo.ClearPossChoices();
              lookahead_todo.ClearCPossChoices();
              tmpf_RestoreGraph2(graph, &lookahead_stack, &lookahead_todo, false);
            } // lookahead check for minus
          } // error and canbeprop-check           
            
          if(!error)
            todo->PushCPossChoices(next);
        } else
        if(next->GetType() == type_cheadnode)
          todo->PushCPossChoices(next);
      } else {
        finish = true;
        todo->PushCPossChoices(next);
      } // if next == last
    } else // if next != NULL and uncolored    
    if(next == last) {
      finish = true;
    }
  }

  delete lookahead_op;
  graph->EndLookahead();

  return val;
}

/***************************************************************************
  class COperatorN
****************************************************************************/
COperatorN::COperatorN() : CDetOperator() {

  CREATEOBJECT("COperatorN");

}

COperatorN::~COperatorN() {

  DELETEOBJECT("COperatorN");

}

TRetOperator COperatorN::Call(CGraph* graph,
                              CStack* stack,
                              CTodoLists *todo,
                              CStatusInformation* status) {

	CHECK_POINTER("COperatorN::Call(graph)", graph);
	CHECK_POINTER("COperatorN::Call(stack)", stack);
	CHECK_POINTER("COperatorN::Call(todo)" , todo);

  INC_COUNT(methode_operator_n_call);
  
  TRetOperator val, val2;

  val2 = graph->ColorNodes(color_weak_plus | color_none, type_cbodynode,
                           color_minus, stack, todo, status);

  if(val2 == return_colorerror)
    return val2;

  val = graph->ColorNodes(color_weak_plus | color_none, type_cheadnode,
                          color_minus, stack, todo, status);

  if(val == return_colorerror)
    return val;

  if(val == return_changed || val2 == return_changed)
    return return_changed;
  else
    return return_unchanged;

}

/***************************************************************************
  class COperatorNSecure
****************************************************************************/
COperatorNSecure::COperatorNSecure() : CDetOperator() {

  CREATEOBJECT("COperatorNSecure");

}

COperatorNSecure::~COperatorNSecure() {

  DELETEOBJECT("COperatorNSecure");

}

TRetOperator COperatorNSecure::Call(CGraph* graph,
                                    CStack* stack,
                                    CTodoLists *todo,
                                    CStatusInformation* status) {

	CHECK_POINTER("COperatorNSecure::Call(graph)", graph);
	CHECK_POINTER("COperatorNSecure::Call(stack)", stack);
	CHECK_POINTER("COperatorNSecure::Call(todo)" , todo);

  INC_COUNT(methode_operator_nsecure_call);

  TRetOperator val, val2;

  val2 = graph->ColorNodes(color_weak_plus | color_none, type_cbodynode,
                           color_minus, stack, todo, status, true);

  if(val2 == return_colorerror)
    return val2;

  val = graph->ColorNodes(color_weak_plus | color_none, type_cheadnode,
                          color_minus, stack, todo, status, true);

  if(val == return_colorerror)
    return val;

  if(val == return_changed || val2 == return_changed)
    return return_changed;
  else
    return return_unchanged;

}

/***************************************************************************
  class COperatorV
****************************************************************************/
COperatorV::COperatorV() : CDetOperator() {

  CREATEOBJECT("COperatorV");

}

COperatorV::~COperatorV() {

  DELETEOBJECT("COperatorV");

}

TRetOperator COperatorV::Call(CGraph* graph,
                              CStack* stack,
                              CTodoLists *todo,
                              CStatusInformation* status) {

  CHECK_POINTER("COperatorV::Call(graph)", graph);
  CHECK_POINTER("COperatorV::Call(stack)", stack);
  CHECK_POINTER("COperatorV::Call(todo)" , todo);

  TRetOperator val = return_unchanged;
  
/*  INC_COUNT(methode_operator_v_call);

  TBodyNodeVector *nodes = graph->GetBodyNodes();
  TBodyNodeVectorIterator ite;

  TNodeSet plus_colored;
  TNodeSet minus_colored;
  TBodyNodeVector uncolored = *nodes;

  THeadNodeSetIterator ite2, end2;
  // get all plus and minus colored rules
  for(ite=nodes->begin();ite!=nodes->end();ite++) {

    CBodyNode *node = *ite;
    TId id = node->GetId();

    switch (node->GetColor()) {

      case color_plus :
        plus_colored[id] = node;
        uncolored.erase(id);

        // add head nodes
        end2 = node->GetSuccessors().end();
        for(ite2 = node->GetSuccessors().begin(); ite2 != end2; ite2++) {
          plus_colored[(*ite2)->GetId()] = *ite2;
        } // for
        break;

      case color_minus :
        minus_colored[id] = node;
        uncolored.erase(id);
        break;

      default :
        break;

    } // switch

  } // for

  // compute the max-supp-graph V
  long old = -1;
  long changed = 0;
  TNodeSet new_set = uncolored;

  while(old != changed) {

    old = changed;

    for(ite=uncolored.begin();ite!=uncolored.end();ite++) {

    	CBodyNode *node = (CBodyNode*)ite->second;
     	TId id = ite->first;

      if(node->GetColor() == color_none &&
         node->Supported(&plus_colored)) {

        plus_colored[id] = node;
        new_set.erase(id);
        changed++;

      	// add head nodes
        end2 = node->GetSuccessors().end();
        for(ite2 = node->GetSuccessors().begin(); ite2 != end2; ite2++) {
          plus_colored[(*ite2)->GetId()] = *ite2;
        } // for
      } // if (uncolored and supp)
    } // for

    uncolored = new_set;

  } // while

  nodes = graph->GetBodyNodes();
  
  for(ite=nodes->begin();ite!=nodes->end();ite++) {

  	CNode *node = ite->second;
    if(node->GetColor() != color_minus &&
       plus_colored.find(node->GetId()) == plus_colored.end()) {

      if(!graph->ColorNode(node, color_minus, stack, false, color_none,
                           todo, status)) {

        return return_colorerror;

      } // if (colornode)

      val = return_changed;

    } // if (!minus and in plus-colored)

  } // for
*/
  return val;

}

/***************************************************************************
  class COperatorV2
****************************************************************************/
COperatorV2::COperatorV2() : CDetOperator() {

  CREATEOBJECT("COperatorV2");

}

COperatorV2::~COperatorV2() {

  DELETEOBJECT("COperatorV2");

}

TRetOperator COperatorV2::Call(CGraph* graph,
                               CStack* stack,
                               CTodoLists *todo,
                               CStatusInformation* status) {

	CHECK_POINTER("COperatorV2::Call(graph)", graph);
	CHECK_POINTER("COperatorV2::Call(stack)", stack);
	CHECK_POINTER("COperatorV2::Call(todo)" , todo);

  INC_COUNT(methode_operator_v2_call);

  TRetOperator val;

/*  // new stack
  CStack *new_stack = new CStack;
  CTodoLists *ms_todo = new CTodoLists();

  COperatorMS ms;
  COperatorNSecure n;

  // disable ignore, todo and jumping
  TTypeEnum e = graph->GetColorNode()->GetEnabled();
  graph->GetColorNode()->Enable(type_cn_none|type_cn_todo);

  // copy all choice points into todo queue for ms-operator
  ms_todo->GetPsTodoQueue()->CopyQueue(todo->GetCPTodoQueue());

  // generate maximal support
  val = ms.Call(graph, new_stack, ms_todo);

  // enable ignore, todo and jumping
  graph->GetColorNode()->Enable(e);

  if(val != return_colorerror) {

    val = n.Call(graph, stack, todo, status);

  } else {

    val = return_unchanged;

  }

  // restore nstack
  while(!new_stack->empty()) {

    // take top element
    TStackElement top = new_stack->top();

    // restore node
    graph->LoadState(&top, new_stack, todo);

    // delete top stack element
    new_stack->pop();

  }

  delete ms_todo;
  delete new_stack;
  */
  return val;

}

/***************************************************************************
  class COperatorV3
****************************************************************************/
COperatorV3::COperatorV3() : CDetOperator() {

  CREATEOBJECT("COperatorV3");

}

COperatorV3::~COperatorV3() {

  DELETEOBJECT("COperatorV3");

}

TRetOperator COperatorV3::Call(CGraph* graph,
                               CStack* stack,
                               CTodoLists *todo,
                               CStatusInformation* status) {

	CHECK_POINTER("COperatorV3::Call(graph)", graph);
	CHECK_POINTER("COperatorV3::Call(stack)", stack);
	CHECK_POINTER("COperatorV3::Call(todo)" , todo);

  INC_COUNT(methode_operator_v3_call);

  TRetOperator val = return_unchanged;

/*  CNonPriorityQueue* backup_list = new CNonPriorityQueue();
  CNonPriorityQueue* backup_list2 = new CNonPriorityQueue();

  // save queue
  backup_list->CopyQueue(todo->GetMinusTodoQueue());

  // set max_support value of all (minus colored) nodes to
  // false and put succs into queue
  while(!todo->GetMinusTodoQueue()->Empty()) {

    CNode* node = todo->GetMinusTodoQueue()->GetHead();

    // value is set to false (already tested) or node is colored plus
    if(false == node->GetMaxSupport() || node->GetColor() == color_plus)
      continue;

    node->SetMaxSupport(false);

    // insert successors into queue
    switch(node->GetType()) {

      case type_cbodynode :
        // put successors into queue
        todo->GetMinusTodoQueue()->InsertSet(
                ((CBodyNode*)node)->GetSuccessors());
        break;

      case type_cheadnode :
        // put 0-successors into queue
        todo->GetMinusTodoQueue()->InsertSet(
                ((CHeadNode*)node)->GetZeroSuccessors());

        backup_list->Insert(node);
        break;

      default:
        break;

    } // switch

  } // while

  // set max_support value of s-supported nodes to true and put succs
  // into queue put s-unsupported nodes into Backuplist2
  while(!backup_list->Empty()) {

    CNode* node = backup_list->GetHead();

    // already tested
    if(node->GetMaxSupport() || node->GetColor() == color_minus)
      continue;

    bool s_supp = node->IsMaxSupported();

    // s-supported
    node->SetMaxSupport(s_supp);
    if(!s_supp) {

      backup_list2->Insert(node);

    }

    switch(node->GetType()) {

      case type_cbodynode :
        // put successors into queue
        backup_list->InsertSet(((CBodyNode*)node)->GetSuccessors());
        break;

      case type_cheadnode :
        // put 0-successors into queue
        if(s_supp)
          backup_list->InsertSet(((CHeadNode*)node)->GetZeroSuccessors());
        break;

      default:
        break;

    } // switch

  } // while

  // color all nodes in backup_list2 to minus if not s-supported
  while(!backup_list2->Empty()) {

    CNode* node = backup_list2->GetHead();

    // do not color minus
    if(node->GetMaxSupport())
      continue;

    // s-supported : should not happen
    if(node->IsMaxSupported()) {

      // do not color minus
      node->SetMaxSupport(true);

    } else
    // is not colored plus OR minus
    if(node->GetColor() < color_minus) {

      if(!graph->ColorNode(node, color_minus, stack, false, color_none,
                           todo, status, false)) {

        delete backup_list;
        delete backup_list2;

        return return_colorerror;

      } // if (colornode)

      val = return_changed;

    } // if (<minus)

    switch(node->GetType()) {

      case type_cbodynode :
        // put successors into queue
        backup_list2->InsertSet(((CBodyNode*)node)->GetSuccessors());
        break;

      case type_cheadnode :
        // put 0-successors into queue
        backup_list2->InsertSet(((CHeadNode*)node)->GetZeroSuccessors());
        break;

      default:
        break;

    } // switch

  } // while

  delete backup_list;
  delete backup_list2;

  todo->GetMinusTodoQueue()->Clear();
  */
  return val;

}

/***************************************************************************
  class COperatorV4
****************************************************************************/
COperatorV4::COperatorV4() : CDetOperator() {

  CREATEOBJECT("COperatorV4");

}

COperatorV4::~COperatorV4() {

  DELETEOBJECT("COperatorV4");

}

TRetOperator COperatorV4::Call(CGraph* graph, CStack* stack, CTodoLists *todo,
                CStatusInformation* status) {

  CHECK_POINTER("COperatorV4::Call(graph)", graph);
  CHECK_POINTER("COperatorV4::Call(stack)", stack);
  CHECK_POINTER("COperatorV4::Call(todo)" , todo);
  INC_COUNT(methode_operator_v4_call);

  TRetOperator val = return_unchanged;

  TIdSet head_set;
  TIdSet body_set;
  TQueue nodes_queue;
  
  // 1. iterate throw the minus colored queue
  while(!todo->EmptyMinus()) {
    CNode* node = todo->PopMinus();
    
    if(node->GetColor() != color_plus) {
      // put node into backup queue
      nodes_queue.push(node);

      if(node->GetType() == type_cheadnode) {
        // not yet tested
        if(head_set.find(node->GetId()) == head_set.end()) {
          // put node into head set and put 0-successors into minus queue
          head_set.insert(node->GetId());
          node->SetIsInV4Set(true);
          todo->PushMinus(&((CHeadNode*)node)->GetZeroSuccessors());
        }
      } else {
        if(body_set.find(node->GetId()) == body_set.end()) {
          // put node into body set and put successors into minus queue
          body_set.insert(node->GetId());
          node->SetIsInV4Set(true);
          todo->PushMinus(&((CBodyNode*)node)->GetSuccessors());
        }
      } // body type
    } // if
  } // while

  THeadNodeSetIterator hite;
  THeadNodeSetIterator hend;

  TBodyNodeSetIterator bite, b2ite;
  TBodyNodeSetIterator bend, b2end;

  // 2. iterate throw the backup queue
  while(!nodes_queue.empty()) {
    CNode* node = nodes_queue.front();
    nodes_queue.pop();
    
    // do not test node not in {head/body}_set!
    if(node->GetColor() != color_minus && node->IsInV4Set()) {
      if(node->GetType() == type_cbodynode) {
        hite = ((CBodyNode*)node)->GetZeroPredecessors().begin();
        hend = ((CBodyNode*)node)->GetZeroPredecessors().end();

        for(; hite!=hend; hite++) {
          // is pred in head_set?
          if(head_set.find((*hite)->GetId()) != head_set.end()) 
            break;
        } // for

        // if no pred is in head_set!
        if(hite == hend) {
          // if all head nodes are not in head_set
          //    erase element from body_set and test its successors
          body_set.erase(node->GetId());
          node->SetIsInV4Set(false);
          hite = ((CBodyNode*)node)->GetSuccessors().begin();
          hend = ((CBodyNode*)node)->GetSuccessors().end();
          for(; hite!=hend; hite++) {
            nodes_queue.push(*hite);
          }
        }
      } else {
        bite = ((CHeadNode*)node)->GetPredecessors().begin();
        bend = ((CHeadNode*)node)->GetPredecessors().end();
          
        for(; bite!=bend; bite++) {
          CNode *p = *bite;
          // is this pred in the body_set or not?
          if(body_set.find(p->GetId()) == body_set.end() && p->GetColor() != color_minus) {
            // if one body node is not in body_set and not colored minus
            //    erase element from head_set and test its 0-successors
            head_set.erase(node->GetId());
            node->SetIsInV4Set(false);
            b2ite = ((CHeadNode*)node)->GetZeroSuccessors().begin();
            b2end = ((CHeadNode*)node)->GetZeroSuccessors().end();
            for(; b2ite!=b2end; b2ite++) {
              nodes_queue.push(*b2ite);
            }
          }
        } // for
      } // node type
    } // if
  } // while
  
  // 3. color all node in body_set and head_set minus!
  TIdSetIterator ite = head_set.begin();
  TIdSetIterator end = head_set.end();
  for(; ite!=end; ite++) {
    if(graph->GetHeadNode(*ite)->GetColor() != color_minus) {
      if(!graph->ColorNode(graph->GetHeadNode(*ite), color_minus, stack, false, color_none, todo, status))
        return return_colorerror;

      val = return_changed;
    } // if (not minus)
  } // for

  ite = body_set.begin();
  end = body_set.end();
  for(; ite!=end; ite++) {
    if(graph->GetBodyNode(*ite)->GetColor() != color_minus) {
      if(!graph->ColorNode(graph->GetBodyNode(*ite), color_minus, stack, false, color_none, todo, status))
        return return_colorerror;

      val = return_changed;
    } // if (not minus)
  } // for
//  cout << "OpV4 - Finish" << endl;

  todo->ClearMinus();
  return val;
}

/***************************************************************************
  class COperatorV5
****************************************************************************/
COperatorV5::COperatorV5() : CDetOperator() {

  CREATEOBJECT("COperatorV5");

}

COperatorV5::~COperatorV5() {

  DELETEOBJECT("COperatorV5");

}

TRetOperator COperatorV5::Call(CGraph* graph,
                               CStack* stack,
                               CTodoLists *todo,
                               CStatusInformation* status) {

	CHECK_POINTER("COperatorV5::Call(graph)", graph);
	CHECK_POINTER("COperatorV5::Call(stack)", stack);
	CHECK_POINTER("COperatorV5::Call(todo)" , todo);

  INC_COUNT(methode_operator_v5_call);

  TRetOperator val = return_unchanged;

/*  CNonPriorityQueue nodes_queue;
  CNonPriorityQueue minus_queue;

  // 1. iterate throw the minus colored queue
  while(!todo->GetMinusTodoQueue()->Empty()) {

    CNode* node = todo->GetMinusTodoQueue()->GetHead();

    // skip if node is plus or already tested
    if((node->GetColor() != color_plus && node->GetMaxSupport()) ||
        node->GetColor() == color_minus) {

      // put node into backup queue
      nodes_queue.Insert(node);
      node->SetMaxSupport(false);

      switch(node->GetType()) {

        case type_cheadnode :
          todo->GetMinusTodoQueue()->InsertSet(
                  ((CHeadNode*)node)->GetZeroSuccessors());
          break;

        case type_cbodynode :
          todo->GetMinusTodoQueue()->InsertSet(
                  ((CBodyNode*)node)->GetSuccessors());
          break;

        default:
          break;

      } // switch

    } // if

  } // while

  // 2. iterate throw the backup queue
  while(!nodes_queue.Empty()) {

    CNode* node = nodes_queue.GetHead();

    if(node->GetColor() != color_minus && !node->GetMaxSupport()) {

      if(node->IsMaxSupported()) {

        node->SetMaxSupport(true);
        switch(node->GetType()) {

          case type_cheadnode :
            nodes_queue.InsertSet(((CHeadNode*)node)->GetZeroSuccessors());
            break;

          case type_cbodynode :
            nodes_queue.InsertSet(((CBodyNode*)node)->GetSuccessors());
            break;

          default:
            break;

        } // switch

      } else {

        minus_queue.Insert(node);

      } // if (max-supp)

    } // if

  } // while

  // 3. color all node in body_set and head_set minus!
  int num = 0;
  while(!minus_queue.Empty()) {

    CNode* node = minus_queue.GetHead();

    if(!node->GetMaxSupport()) {

      if(!graph->ColorNode(node, color_minus, stack, false, color_none,
                           todo, status)) {

        return return_colorerror;

      } // if (colornode)

      num++;
      val = return_changed;

    } // if (max-supp)

  } // while

  todo->GetMinusTodoQueue()->Clear();
  */
  return val;

}

/***************************************************************************
  class COperatorU
****************************************************************************/
COperatorU::COperatorU() : CDetOperator() {

  CREATEOBJECT("COperatorU");

}

COperatorU::~COperatorU() {

  DELETEOBJECT("COperatorU");

}

TRetOperator COperatorU::Call(CGraph* graph, CStack* stack, CTodoLists* todo, CStatusInformation* status) {
  CHECK_POINTER("COperatorU::Call(graph)", graph);
  CHECK_POINTER("COperatorU::Call(stack)", stack);
  CHECK_POINTER("COperatorU::Call(todo)" , todo);
  INC_COUNT(methode_operator_u_call);

  THeadNodeSetIterator hite, hend;
  TBodyNodeSetIterator bite, bend;
  
  TBodyNodeVectorIterator ite;
  THeadNodeVectorIterator iteh;
  TBodyNodeVector* nodes = graph->GetBodyNodes();
  TBoolSet suppbodynodes;
  TBoolSet suppheadnodes;
  bool changed = true;
  
/*  cout << "visit operator U" << endl;
  cout << *graph << endl;
  */
  while(changed) {
    changed = false;

    for(ite=nodes->begin();ite!=nodes->end();ite++) {
      CBodyNode *node = *ite;

      if(node->GetColor() != color_minus && suppbodynodes.find(node->GetId()) == suppbodynodes.end()) {
        bool supp = true;
        hite = node->GetZeroPredecessors().begin();
        hend = node->GetZeroPredecessors().end();
        for(; hite != hend; hite++) {
          // if not in current supp-head-list
          if(suppheadnodes.find((*hite)->GetId()) == suppheadnodes.end())
            supp = false;
        } // for

        // node is supported :)
        if(supp) {
          changed = true;

          // put node and successors into bool-set
          suppbodynodes[node->GetId()] = true;
          hite = node->GetSuccessors().begin();
          hend = node->GetSuccessors().end();
          for(; hite != hend; hite++) {
            if((*hite)->GetColor() != color_minus)
              suppheadnodes[(*hite)->GetId()] = true;
          } // for
        } // if (supp)
      } // if
    } // for
  } // while
  
  TRetOperator val = return_unchanged;
  // color all uncolored not in maximal support graph
  for(iteh = graph->GetHeadNodes()->begin(); iteh != graph->GetHeadNodes()->end(); iteh++) {

    // not in bool-set => color minus
    if((*iteh)->GetColor() != color_minus && suppheadnodes.find((*iteh)->GetId()) == suppheadnodes.end()) {
//      cout << "color headnode " << (*iteh)->GetId() << endl;
      if(!graph->ColorNode(*iteh, color_minus, stack, false, color_none, todo, status)) {
        return return_colorerror;
      }
      val = return_changed;
    } // if
  } // for
  
  // color all uncolored not in maximal support graph
  for(ite = graph->GetBodyNodes()->begin(); ite != graph->GetBodyNodes()->end(); ite++) {

    // not in bool-set => color minus
    if((*ite)->GetColor() != color_minus && suppbodynodes.find((*ite)->GetId()) == suppbodynodes.end()) {
//      cout << "color bodynode " << (*ite)->GetId() << endl;
      if(!graph->ColorNode(*ite, color_minus, stack, false, color_none, todo, status)) {
        return return_colorerror;
      }
      val = return_changed;
    } // if
  } // for

  return val;
}

/***************************************************************************
  class COperatorPre
****************************************************************************/
COperatorPre::COperatorPre() : CDetOperator() {

  CREATEOBJECT("COperatorPre");

}

COperatorPre::~COperatorPre() {

  DELETEOBJECT("COperatorPre");

}

TRetOperator COperatorPre::Call(CGraph* graph, CStack* stack, CTodoLists *todo,
                CStatusInformation* status) {

  CHECK_POINTER("COperatorPre::Call(graph)", graph);
  CHECK_POINTER("COperatorPre::Call(stack)", stack);
  CHECK_POINTER("COperatorPre::Call(todo)" , todo);
  INC_COUNT(methode_operator_pre_call);

  TRetOperator val = return_unchanged;

  TBodyNodeVectorIterator ite = graph->GetBodyNodes()->begin();
  TBodyNodeVectorIterator end = graph->GetBodyNodes()->end();
  for(; ite!=end; ite++) {
    CBodyNode *node = *ite;

    if(node->GetColor() != color_ignore) {
      // color facts with plus
      if (node->GetOnePredecessors().empty() && node->GetZeroPredecessors().empty()) {
        graph->ColorNode(node, color_plus, stack, false, color_none, todo, status);
        val = return_changed;
      } else {
        if (node->SelfBlocker()) {
          if(graph->ColorNode(node, color_minus, stack, false, color_none, todo, status)) {
            val = return_changed;
          } else
            return return_colorerror;
        } else {
          if(node->Supported()) {
            todo->PushPossChoices(node);
            INC_COUNT(queue_cp_call);
          }
          todo->PushCPossChoices(node);
        } // if (self-blocker/supp)
      } // if (empty predecessors)
    } // color ignore
  } // for

  THeadNodeVectorIterator hite = graph->GetHeadNodes()->begin();
  THeadNodeVectorIterator hend = graph->GetHeadNodes()->end();  
  for(; hite!=hend; hite++) {
    CHeadNode *node = *hite;
    if(node->GetColor() == color_none)
      todo->PushCPossChoices(node);
  } // for

  // clear stack and delete data
  while(!stack->empty()) {
    stack->pop();
  } // while
  
  return val;  
}

/***************************************************************************
  Generic stuff
****************************************************************************/

/*! Generates from the input an operator */
CDetOperator* CreateDetOperator(string op) {

  if(op == "P")
    return (CDetOperator*)(new COperatorPs());

  if(op == "LABH")
    return (CDetOperator*)(new COperatorLABH());

  if(op == "LAB")
    return (CDetOperator*)(new COperatorLAB());

  if(op == "U")
    return (CDetOperator*)(new COperatorU());

  if(op == "V")
    return (CDetOperator*)(new COperatorV4());

  if(op == "B")
    return (CDetOperator*)(new COperatorBP());

  if(op == "None")
    return (CDetOperator*)(new CDetOperatorNone());

  cerr << "Error: Unknown det. operator ["<<op<<"]!" << endl;
   
  return NULL;
  
}

/*! Generates from the input an operator */
CDetOperator* CreatePreOperator(string op) {
  
  if(op == "Pre")
     return (CDetOperator*)(new COperatorPre());

  cerr << "Error: Unknown pre processing operator ["<<op<<"]!" << endl;

  return NULL;
  
}

/*! Generates from the input an operator */
CDetOperator* CreateEndOperator(string op) {
  
  if(op == "N")
    return (CDetOperator*)(new COperatorN());

  if(op == "None")
    return (CDetOperator*)(new CDetOperatorNone());

  cerr << "Error: Unknown post processing operator ["<<op<<"]!" << endl;

  return NULL;
  
}

/*! Generates from the input an non-det. operator */
CNdOperator* CreateNdOperator(string op) {
  
  if(op == "C")
    return (CNdOperator*)(new COperatorCQ());

  if(op == "D")
    return (CNdOperator*)(new COperatorDH());

  cerr << "Error: Unknown non-det. operator ["<<op<<"]!" << endl;

  return NULL;
  
}

/*! Generates the aggregation tree out of the input string*/
bool GenerateOperator(string op, CDetOperator*& out) {

  int len = op.size();
  int i, counter, pos;
  CDetOperator *o = NULL;
  CDetOperator *o2 = NULL;
  string buffer1;
  string buffer2;

  if(len == 0) {
    
    out = NULL;
    cerr << "Error: Unexpected end of deterministic operator definition!" << endl;
    return false;
    
  } // if (len)

  // only single operator like P
  if(-1 == (signed int)op.find(",") &&
     -1 == (signed int)op.find("(") &&
     -1 == (signed int)op.find("*")) {

    out = CreateDetOperator(op);

    if(out == NULL)
      return false;
    else
      return true;
      
  } else {
    
    if(op[0] == '(') {
      
      // find corresponding ')'
      counter = 1;
      for(i=1;i!=len;i++) {
        
        if(op[i] == '(') counter++;else
        if(op[i] == ')') counter--;
        if(counter == 0)
          break;
          
      } // for

      buffer1 = op.substr(1, i-1);
      pos = i;
      
    } else {
      
      for(i=1;i!=len;i++) {
        
      	if(op[i] == ',' ||
           op[i] == '(' ||
           op[i] == ')' ||
           op[i] == '*')
          break;
          
      } // for
            
      buffer1 = op.substr(0, i);
      pos = i-1;
      
    } // if (')')
   
    // only *-operator at the end of the char-list
    if(pos+2 == len && op[pos+1] == '*') {
      
      if(!GenerateOperator(buffer1, o)) {
        
        out = NULL;
        return false;
        
      } // if

      out = (CDetOperator*)(new CAggregationStar());
      ((CAggregationStar*)out)->SetOperator(o);

      return true;
      
    } else
    if(op[pos+1] == ',') {
      
    	buffer2 = op.substr(pos+2, len);

      if(!GenerateOperator(buffer1, o)) {
        
        out = NULL;
        return false;
        
      } // if
      
      if(!GenerateOperator(buffer2, o2)) {
        
        delete o;
        out = NULL;
        return false;
        
      } // if

      out = (CDetOperator*)(new CAggregationSequence());
      ((CAggregationSequence*)out)->SetFirst(o);
      ((CAggregationSequence*)out)->SetSecond(o2);

      return true;
      
    } else
    if(pos+1 == len) {
      
      // only delete of (...)
      return GenerateOperator(buffer1, out);
    } else
    if(op[pos+1] == '*' && op[pos+2] == ',') {
      
    	string b = buffer1;
      buffer1 = "(";
      buffer1 += b;
      buffer1 += ")*";

      pos++;

			buffer2 = op.substr(pos+2, len);			

      if(!GenerateOperator(buffer1, o)) {
        
        out = NULL;
        return false;
        
      } // if

      if(!GenerateOperator(buffer2, o2)) {
        
        delete o;
        out = NULL;
        return false;
        
      } // if

      out = (CDetOperator*)(new CAggregationSequence());
      ((CAggregationSequence*)out)->SetFirst(o);
      ((CAggregationSequence*)out)->SetSecond(o2);

      return true;
      
    } // if
    
  } // if

  cerr << "Error: Unknown character sequence for deterministic operator generation!" << endl;

  out = NULL;
  return false;
  
}

/*! Generates from the input a heuristic object */
CHeuristic* CreateHeuristic(string op) {
  
  if(op == "None")
		return (CHeuristic*)(new CHeuristicNone());

  if(op == "S1")
		return (CHeuristic*)(new CHeuristicS1());

  if(op == "S2")
		return (CHeuristic*)(new CHeuristicS2());

  if(op == "SR")
		return (CHeuristic*)(new CHeuristicSR());

  if(op == "D1")
		return (CHeuristic*)(new CHeuristicD1());

  if(op == "DR")
		return (CHeuristic*)(new CHeuristicDR());

  if(op == "Alpha")
		return (CHeuristic*)(new CHeuristicAlphabetical());

  cerr << "Error: Unknown heuristics ["<<op<<"]!" << endl;

  return NULL;
  
}

bool Extract(string in, string& op, string& rest) {
  
	unsigned int pos = in.find(":");

	if(pos >= in.size())
		return false;

  op = in.substr(0, pos);
  rest = in.substr(pos+1, in.size());

	return true;
  
}

bool ConflictOperators(TTypeEnum det_ops, CNdOperator *ndet, CDetOperator *end) {
  CHECK_POINTER("ConflictOperators(ndet)", ndet);
  CHECK_POINTER("ConflictOperators(end)" , end);
 
  // double star is selected!
  if(det_ops & type_caggregation_error) { 
    cerr << "Operator conflict: Double star aggregations ()* is not allowed." << endl;
    return true;
  }

  // Ps and P are not selected!
  if(!(det_ops & type_coperator_ps)) {
    cerr << "Operator conflict: No forward propagation operator P is selected." << endl;
    return true;
  }

//  7: ERROR for clumpy_4_4_3.lp (Vermutung: V im lookahead) : std::string operators = "Pre:D:(P,LABH):N:None";
//  8: OK std::string operators = "Pre:C:(((P,B)*,U)*,LABH):None:None";
//  9: OK std::string operators = "Pre:D:((P,B)*,V)*:None:None";
// 10: OK std::string operators = "Pre:D:((P,V)*,LABH):None:None";
// 11: ERROR for hamk6.lp (Vermutung: V im lookahead) : std::string operators = "Pre:D:((P,B)*,LABH):N:None";
// 12: OK std::string operators = "Pre:D:(((P,B)*,V)*,LABH):None:None";

  // use D with V4 and C with U
  if(type_coperator_cq == ndet->GetType() && !(det_ops & type_coperator_u)) {
    cerr << "Operator conflict: Use operator U with choice operator C." << endl;
    return true;
  }
  
  if(type_coperator_dh == ndet->GetType() && det_ops & type_coperator_u) {
    cerr << "Operator conflict: Use operator V with choice operator D." << endl;
    return true;
  }
   
  // if U, V, V2 or V4 is not selected N must be selected!
  if(!(det_ops & type_coperator_u || det_ops & type_coperator_v4) && !(end->GetOperatorID() & type_coperator_n)) {
    cerr << "Operator conflict: If operator V or U is not selected use operator N." << endl;
    return true;
  }
  
  if(ndet->GetType() == type_coperator_dh && det_ops & type_coperator_ps && det_ops & type_coperator_labh && !(det_ops & type_coperator_v4)) {
    cerr << "Operator conflict: Use operator V." << endl;
    return true;
  }
  
  return false;  
}

bool GenerateOperator(string op,
                      string lookahead_op,
                      CDetOperator*& det_out,
											CDetOperator*& pre_out,
											CNdOperator*& ndet_out,
											CDetOperator*& end_out,
                      CHeuristic*& heu_out,
                      CDetOperator*& lookahead_out) {
  
  det_out = NULL;
  pre_out = NULL;
  ndet_out = NULL;
  end_out = NULL;
  heu_out = NULL;
  lookahead_out = NULL;

  string str_det;
  string str_ndet;
  string str_pre;
  string str_end;
  string str_heu;  

  Extract(op, str_pre, op);
  Extract(op, str_ndet, op);
  Extract(op, str_det, op);
  Extract(op, str_end, str_heu);

  pre_out = CreatePreOperator(str_pre);
  if(pre_out == NULL)
    return false;

  ndet_out = CreateNdOperator(str_ndet);
  if(ndet_out == NULL) {
    
  	delete pre_out;
  	pre_out = NULL;
    return false;
    
  } // if

  if(!GenerateOperator(str_det, det_out)) {
    
  	delete pre_out;
  	pre_out = NULL;
  	delete ndet_out;
  	ndet_out = NULL;
    return false;
    
  } // if

  end_out = CreateEndOperator(str_end);
  if(end_out == NULL) {
    
  	delete pre_out;
  	pre_out = NULL;
  	delete ndet_out;
  	ndet_out = NULL;
  	delete det_out;
  	det_out = NULL;
    return false;
    
  } // if

  heu_out = CreateHeuristic(str_heu);
  if(heu_out == NULL) {
    
  	delete pre_out;
  	pre_out = NULL;
  	delete ndet_out;
  	ndet_out = NULL;
  	delete det_out;
  	det_out = NULL;
  	delete end_out;
  	end_out = NULL;
    return false;
    
  } // if

  if(!GenerateOperator(lookahead_op, lookahead_out)) {
    
  	delete pre_out;
  	pre_out = NULL;
  	delete ndet_out;
  	ndet_out = NULL;
  	delete det_out;
  	det_out = NULL;
  	delete end_out;
  	end_out = NULL;
  	delete heu_out;
  	heu_out = NULL;
    return false;
    
  } // if

  if(ConflictOperators(det_out->GetOperatorID(), ndet_out, end_out)) {
    
    delete pre_out;
    delete ndet_out;
    delete det_out;
    delete end_out;
    delete heu_out;
    delete lookahead_out;
    pre_out = NULL;
    ndet_out = NULL;
    det_out = NULL;
    end_out = NULL;
    heu_out = NULL;
    lookahead_out = NULL;

    return false;
    
  } // if

  return true;
  
}

}
