// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi

//#include <strstream>
#include <sstream>
#include <iomanip>
#include "timer.h"

CTimer::CTimer () {
  _sec = 0;
  _msec = 0;
}

void CTimer::Start () {
  _timer = clock ();
}

void CTimer::Stop () {
  clock_t ticks = clock () - _timer;
  long s = ticks / CLOCKS_PER_SEC;
  _sec += s;
  _msec += (ticks - s*CLOCKS_PER_SEC)*1000/CLOCKS_PER_SEC;
  if (_msec >= 1000) {
      _msec -= 1000;
      _sec++;
  }
}

void CTimer::Reset () {
  _sec = 0;
  _msec = 0;
}

std::string CTimer::Print () {

  std::istringstream in(std::ios::in | std::ios::out);
  std::ostream out(in.rdbuf ());

  out << _sec << '.' << std::setw(3) << std::setfill('0') << _msec;  
  
  return (in.str());
}
