/***************************************************************************
                          caggregation.cpp  -  description
                             -------------------
    begin                : Tue Jul 29 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "caggregation.h"
#include "print.h"

namespace NS_NOMORE{

/***************************************************************************
  class CAggregation
****************************************************************************/
CAggregation::CAggregation() : CDetOperator() {
  
  CREATEOBJECT("CAggregation");
  
}

CAggregation::~CAggregation() {
  
  DELETEOBJECT("CAggregation");
  
}

/***************************************************************************
  class CAggregationStar
****************************************************************************/
CAggregationStar::CAggregationStar() : CAggregation(), _operator(NULL) {
  
  CREATEOBJECT("CAggregationStar");

}

CAggregationStar::~CAggregationStar() {

  DELETEOBJECT("CAggregationStar");

  if(_operator != NULL)
    delete _operator;

  _operator = NULL;
  
}

void CAggregationStar::SetOperator(CDetOperator *op) {

  CHECK_POINTER("CAggregationStar::SetOperator(op)", op);

  if(_operator != NULL)
    delete _operator;

  _operator = op;
  
}

TRetOperator CAggregationStar::Call(CGraph* graph,
                                    CStack* stack,
                                    CTodoLists *todo,
                                    CStatusInformation* status) {
  
	CHECK_POINTER("CAggregationStar::Call(graph)", graph);
	CHECK_POINTER("CAggregationStar::Call(stack)", stack);
	CHECK_POINTER("CAggregationStar::Call(todo)" ,  todo);

  CHECK_POINTER("CAggregationStar::Call() -> operator", GetOperator());

  TRetOperator ret;
  int loop = 0;
  while(return_changed == (ret = GetOperator()->Call(graph, stack, todo, status))) {
    loop++;
  }

  if(loop > 0 && ret != return_colorerror)
    return return_changed;
  else
    return ret;
}

bool CAggregationStar::operator==(COperator& op) {

  if(op.GetType() != GetType())
    return false;

  if(GetOperator() == NULL) {
    
    if(((CAggregationStar*)&op)->GetOperator() == NULL)
      return true;
    else
      return false;
      
  }

  if(((CAggregationStar*)&op)->GetOperator() == NULL)
    return false;

  return
    (GetOperator()->operator==(*((CAggregationStar*)&op)->GetOperator()));

}

bool CAggregationStar::operator!=(COperator& op) {

  return !(this->operator==(op));

}

TTypeEnum CAggregationStar::GetOperatorID() {

  if(GetOperator() == NULL)
    return type_none;
  
  if(GetOperator()->GetType() == type_caggregation_star)
    return type_caggregation_error | GetOperator()->GetOperatorID();
    
  return GetOperator()->GetOperatorID();
  
}

/***************************************************************************
  class CAggregationSequence
****************************************************************************/
CAggregationSequence::CAggregationSequence() : CAggregation(),
                                               _first_operator(NULL),
                                               _second_operator(NULL) {
  
  CREATEOBJECT("CAggregationSequence");

}

CAggregationSequence::~CAggregationSequence() {
  
  DELETEOBJECT("CAggregationSequence");
  
  if(_first_operator != NULL)
    delete _first_operator;

  if(_second_operator != NULL)
    delete _second_operator;

  _first_operator = NULL;
  _second_operator = NULL;
  
}

void CAggregationSequence::SetFirst(CDetOperator *op) {

  CHECK_POINTER("CAggregationSequence::SetFirst(op)", op);

  if(_first_operator != NULL)
    delete _first_operator;

  _first_operator = op;
  
}

void CAggregationSequence::SetSecond(CDetOperator *op) {
  
	CHECK_POINTER("CAggregationSequence::SetSecond(op)", op);

  if(_second_operator != NULL)
    delete _second_operator;

  _second_operator = op;
  
}

TRetOperator CAggregationSequence::Call(CGraph* graph,
                                        CStack* stack,
                                        CTodoLists *todo,
                                        CStatusInformation* status) {
  
	CHECK_POINTER("CAggregationSequence::Call(graph)", graph);
	CHECK_POINTER("CAggregationSequence::Call(stack)", stack);
	CHECK_POINTER("CAggregationSequence::Call(todo)" ,  todo);

  CHECK_POINTER("CAggregationStar::Call() -> first" , GetFirst());
  CHECK_POINTER("CAggregationStar::Call() -> second", GetSecond());

  TRetOperator ret1 = GetFirst()->Call(graph, stack, todo, status);
  if(ret1 == return_colorerror)
      return return_colorerror;

  TRetOperator ret2 = GetSecond()->Call(graph, stack, todo, status);
  if(ret2 == return_colorerror)
      return return_colorerror;

  int ret = ret1+ret2;

  // if ret==0 => nothing has changed
  if(ret == 0)
    return return_unchanged;  

  // if ret>0 => coloring change
  return return_changed;
  
}

bool CAggregationSequence::operator==(COperator& agg) {
  
  if(agg.GetType() != GetType())
    return false;

  int x = 0;

  if(GetFirst() == NULL &&
     ((CAggregationSequence*)&agg)->GetFirst() == NULL)
    x++;
  else
  if(GetFirst() != NULL &&
     ((CAggregationSequence*)&agg)->GetFirst() != NULL &&
     GetFirst()->operator==(*((CAggregationSequence*)&agg)->GetFirst()))
    x++;

  if(GetSecond() == NULL &&
     ((CAggregationSequence*)&agg)->GetSecond() == NULL)
    x++;
  else
  if(GetSecond() != NULL &&
     ((CAggregationSequence*)&agg)->GetSecond() != NULL &&
     GetSecond()->operator==(*((CAggregationSequence*)&agg)->GetSecond()))
    x++;

  return x == 2;
  
}

bool CAggregationSequence::operator!=(COperator& agg) {
  
  return !(this->operator==(agg));
  
}

TTypeEnum CAggregationSequence::GetOperatorID() {
  
  TTypeEnum t1 = type_none;
  TTypeEnum t2 = type_none;
  
  if(GetFirst() != NULL)
    t1 = GetFirst()->GetOperatorID();

  if(GetSecond() != NULL)
    t2 = GetSecond()->GetOperatorID();  

  return t1 | t2;
  
}

}
