/***************************************************************************
                          print.cpp  -  description
                             -------------------
    begin                : Tue Aug 19 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "print.h"

/***************************************************************************
 * Counter all important methods                                           *
 ***************************************************************************/
#ifdef PRINTCALLCOUNTER

  /*************************************************************************
   * Counters for counters :)                                              *
   *************************************************************************/
  long methode_supported             = 0;
  long methode_weak_supported        = 0;
  long methode_unsupported           = 0;
  long methode_blocked               = 0;
  long methode_unblocked             = 0;
  long methode_supported_by_set      = 0;
  long methode_totalcoloring         = 0;
  long methode_all_succs_colored     = 0;

  /*************************************************************************
   * Counters for deterministic operators                                  *
   *************************************************************************/
  long methode_operator_none_call    = 0;
  long methode_operator_p_call       = 0;
  long methode_operator_ps_call      = 0;
  long methode_operator_labh_call    = 0;
  long methode_operator_bp_call      = 0;
  long methode_operator_u_call       = 0;
  long methode_operator_ms_call      = 0;
  long methode_operator_v_call       = 0;
  long methode_operator_v2_call      = 0;
  long methode_operator_v3_call      = 0;
  long methode_operator_v4_call      = 0;
  long methode_operator_v5_call      = 0;
  long methode_operator_n_call       = 0;
  long methode_operator_nsecure_call = 0;
  long methode_operator_pre_call     = 0;

  /*************************************************************************
   * Counters for non-deterministic operators                              *
   *************************************************************************/
  long methode_operator_c_call       = 0;
  long methode_operator_cq_call      = 0;
  long methode_operator_d_call       = 0;
  long methode_operator_dh_call      = 0;
  long methode_operator_dq_call      = 0;

  /*************************************************************************
   * Counters for queueing                                                 *
   *************************************************************************/
  long queue_todo_call               = 0;
  long queue_jumping_call            = 0;
  long queue_cp_call                 = 0;
  long count_ignore                  = 0;

  /*************************************************************************
   * Counters for heuristics                                               *
   *************************************************************************/
  long heuristics_s1_call            = 0;
  long heuristics_s2_call            = 0;
  long heuristics_sr_call            = 0;
  long heuristics_d1_call            = 0;
  long heuristics_dr_call            = 0;
  long heuristics_alpha_call         = 0;

  /*************************************************************************
   * More                                                                  *
   *************************************************************************/
  long methode_colornode             = 0;
  long choice_points                 = 0;

#endif

/***************************************************************************
 * class CObjectCounter                                                    *
 ***************************************************************************/
#ifdef _DEBUG

namespace NS_NOMORE{

// instance of object counter
CObjectCounter _object_counter;

CObjectCounter::CObjectCounter() {

}

CObjectCounter::~CObjectCounter() {
  
  DeleteAll();
  
}

void CObjectCounter::CreateObject(std::string type) {
  
  if(_count_list.find(type) != _count_list.end()) {
    
    _count_list[type].Created++;

  } else {

    _count_list[type].Created = 1;
    _count_list[type].Deleted = 0;
    
  }
  
}

void CObjectCounter::DeleteObject(std::string type) {
  
  if(_count_list.find(type) != _count_list.end()) {
    
    _count_list[type].Deleted++;

  } else {
    
    _count_list[type].Created = 0;
    _count_list[type].Deleted = 1;
    
  }
  
}

long CObjectCounter::ObjectCount(std::string type) {
  
  if(_count_list.find(type) != _count_list.end()) {
    
    return _count_list[type].Created-_count_list[type].Deleted;

  } else
    return 0;
    
}

bool CObjectCounter::Clear() {
  
  std::map<std::string, TCounter>::iterator ite;

  for(ite = _count_list.begin(); ite != _count_list.end(); ite++) {
    
    if((ite->second).Created != (ite->second).Deleted)
      return false;

  }   

  return true;
  
}

void CObjectCounter::DeleteAll() {
  
  _count_list.clear();
  
}

std::ostream& operator<<(std::ostream& os, CObjectCounter& obj) {
  
  std::map<std::string, TCounter>::iterator ite;

  os << "Object type : created/deleted \n";
  os << "----------------------------- \n";
  
  for(ite = obj._count_list.begin();
      ite != obj._count_list.end();
      ite++) {
    
    os << ite->first.c_str() << " : "
       << (ite->second).Created << "/"
       << (ite->second).Deleted << "\n";

  }

  return os;
  
}

} // end of namespace

#endif
