/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_COLORERROR_H
#define LIBNOMORE_COLORERROR_H

#include <stdexcept>

namespace NS_NOMORE {

//! Exception thrown to signal an invalid coloring.
/*! This exception is thrown whenever an invalid coloring is found.
 * See \ref Node::setColor "here" for a description of valid colorings.
 *
 */
class ColorError : public std::exception {
public:
  ColorError() : std::exception() {
  }

  const char* what() const throw() {
    return "invalid coloring";
  }
};

} // NS_NOMORE

#endif
