/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_CONSTRAINT_H
#define LIBNOMORE_CONSTRAINT_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

namespace NS_NOMORE {

class Node;
class HeadNode;
class BodyNode;

//! A constraint checks whether a node (body or head) satisfies some condition.
class Constraint {
public:
  //! Constructs the constraint.
  Constraint();

  //! returns true if the given head node satisfies this constraint.
  virtual bool isSatisfiedBy(const HeadNode& n) const = 0;

  //! returns true if the given body node satisfies this constraint.
  virtual bool isSatisfiedBy(const BodyNode& n) const = 0;

  virtual bool supersedes(const Node& n1, const Node& n2) const = 0;

  //! Destroys the constraint.
  virtual ~Constraint();
private:
  Constraint(const Constraint&);
  Constraint& operator=(const Constraint&);
};

}

#endif
