/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_NEG_PRECONDITION_COUNT_HEURISTIC_H
#define LIBNOMORE_NEG_PRECONDITION_COUNT_HEURISTIC_H
#include <static_heuristic.h>
#include <body_node.h>
#include <functional>
namespace NS_NOMORE {

//! Heuristic-Strategy that compares negative preconditions of body nodes.
/*! This class values all body nodes and sets their heuristics values 
 *  to the number of negative preconditions (the count of 1-predecessors).
 *
 *
 *  \note This Strategy may be used with either a Static- or a Dynamic-Heuristic.
 *  But since the heuristic value won't change over the time, the former
 *  is more sensible.
 *
 *  \note This Strategy values only body nodes.
 */
class NegativePreconditionCountStrat {
public:
  typedef size_t ValueType;
  typedef std::greater<ValueType> ComparatorType;
  struct Evaluate {
    void operator()(HeadNode*) const {}
    void operator()(BodyNode* n) const {
      n->installValue(new ValueHolder<ValueType>(n->countNegBodyAtoms()));
    }
  };
  typedef Evaluate EvaluatorType;
};

//! A static heuristic that uses NegativeWeightArcsCountStrat as strategy.
typedef StaticHeuristic<NegativePreconditionCountStrat> NegativePreconditionCount;

}
#endif
