/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_SELECT_UNCOLORED_OPERATOR_H
#define NOMORE_SELECT_UNCOLORED_OPERATOR_H

#include <choice_operator.h>
#include <heuristic.h>

namespace NS_NOMORE {

//! Choice operator that selects uncolored body nodes.
/*! This operator implements the simple choice operator which selects the 
 *  first uncolored body node.
 *  \see ChoiceOperator
 */
class SelectUncolored : public ChoiceOperator, public Constraint {
public:
  //! Creates the choice operator.
  /*! \param grp The graph the operator should work on. 
   *  \param h The heuristics for choosing a node. */ 
  SelectUncolored(Graph& grp, Heuristic* h);

  //! Selects the best uncolored body node.
  /*! \return The node which fulfil the conditions or a null pointer if no node is 
   *          found.*/
  virtual Node* selectChoice();

  //! Nothing to be clean up.
  virtual void postExecute() {
  }

  //! Returns always false. Used for the heuristics.
  virtual bool isSatisfiedBy(const HeadNode& n) const;

  //! Returns true if n is uncolored
  virtual bool isSatisfiedBy(const BodyNode& n) const;

  virtual bool supersedes(const Node& n1, const Node& n2) const;

  //! returns true
  bool validate(const OpSet& ops) const;

  //! Returns the name of the operator.
  static std::string getOpName() {
    return "C";
  }
};

}

#endif
