/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_FULL_STATS_H
#define LIBNOMORE_FULL_STATS_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <iosfwd>
#include <stats.h>
#include <map>
#include <string>
#include <event/channel.h>
namespace NS_NOMORE {

class Graph;
struct HeadNodeColored;
struct BodyNodeColored;
struct BodyNodeColoredChoicePoint;
struct HeadNodeColoredChoicePoint;
struct LookaheadExecution;
struct OperatorStarted;

//! This class gathers some important statistic values like choice points or assignments.
/*!
 * Use this class together with an \ref ObjectFactory "object factory" to let
 * it decorate operators with an \ref InvocationDecorator "invocation decorator".
 * This way this class can gather information about the executed
 * operators (number of executions and names).
 */
class FullStatistics : public Statistics {
public:
  //! Constructs the stats instance.
  FullStatistics();

  //! Returns the number of nodes that were colored as choice points
  long countChoicePoints() const {
    return (choicePointsOfHeadNodes_ + choicePointsOfBodyNodes_);
  }  

  //! Returns the number of body nodes that were colored as choice points.
  long countChoicePointsOfBodyNodes() const {
    return choicePointsOfBodyNodes_;
  }  

  //! Returns the number of head nodes that were colored as choice points.
  long countChoicePointsOfHeadNodes() const {
    return choicePointsOfHeadNodes_;
  }  

  //! Returns the number of choices (i.e. the number of choice points that were recolored)
  long countChoices() const {
    return (choicesOfHeadNodes_ + choicesOfBodyNodes_);
  }  

  //! Returns the number of body node choices
  long countChoicesOfBodyNodes() const {
    return choicesOfBodyNodes_;
  }  

  //! Returns the number of head node choices
  long countChoicesOfHeadNodes() const {
    return choicesOfHeadNodes_;
  }  
  
  //! Returns the number of assignments (i.e. the number of times a color was assigned to a node).
  long countAssignments() const {
    return assignmentsOfHeadNodes_ + assignmentsOfBodyNodes_;
  }

  //! Returns the number of body node assignments 
  long countAssignmentsOfBodyNodes() const {
    return assignmentsOfBodyNodes_;
  }

  //! Returns the number of head node assignments 
  long countAssignmentsOfHeadNodes() const {
    return assignmentsOfHeadNodes_;
  }

  //! Returns the number of nodes tested in lookahead.
  long countLookaheadCheckNodes() const {
    return (lookaheadChoicePointsOfHeadNodes_ + lookaheadChoicePointsOfBodyNodes_);
  }  

  //! Returns the number of body nodes tested in lookahead.
  long countLookaheadCheckBodyNodes() const {
    return lookaheadChoicePointsOfBodyNodes_;
  }  

  //! Returns the number of head nodes tested in lookahead.
  long countLookaheadCheckOfHeadNodes() const {
    return lookaheadChoicePointsOfHeadNodes_;
  }  
  
  //! Returns the number of nodes tested in lookahead.
  long countLookaheadChoiceNodes() const {
    return (lookaheadChoicesOfHeadNodes_ + lookaheadChoicesOfBodyNodes_);
  }  

  //! Returns the number of body nodes tested in lookahead.
  long countLookaheadChoicesBodyNodes() const {
    return lookaheadChoicesOfBodyNodes_;
  }  

  //! Returns the number of head nodes tested in lookahead.
  long countLookaheadChoicesOfHeadNodes() const {
    return lookaheadChoicesOfHeadNodes_;
  }  
  
  //! Returns the number of assignments in lookahead.
  long countLookaheadAssignments() const {
    return lookaheadAssignmentsOfHeadNodes_ + lookaheadAssignmentsOfBodyNodes_;
  }

  //! Returns the number of body node assignments 
  long countLookaheadAssignmentsOfBodyNodes() const {
    return lookaheadAssignmentsOfBodyNodes_;
  }

  //! Returns the number of head node assignments
  long countLookaheadAssignmentsOfHeadNodes() const {
    return lookaheadAssignmentsOfHeadNodes_;
  }

  //! Returns the number of calls to the specified operator.
  long countOperatorCalls(const std::string& op);

  
  void registerWith(event::ChannelManager& m);

  //! event handler for HeadNodeColored events.
  void handle(const HeadNodeColored& e);

  //! event handler for BodyNodeColored events.
  void handle(const BodyNodeColored& e);

  //! event handler for BodyNodeColoredChoicePoint events
  void handle(const BodyNodeColoredChoicePoint& e);

  //! event handler for HeadNodeColoredChoicePoint events
  void handle(const HeadNodeColoredChoicePoint& e);

  //! event handler for LookaheadExecution events
  void handle(const LookaheadExecution& e);

  //! event handler for OperatorStarted events
  void handle(const OperatorStarted& e);
    
  void printReport(std::ostream& os) const;

  virtual Operator* decorate(Operator* op);
  
private:
  long choicePointsOfBodyNodes_;
  long choicePointsOfHeadNodes_;
  long choicesOfBodyNodes_;
  long choicesOfHeadNodes_;
  long assignmentsOfBodyNodes_;
  long assignmentsOfHeadNodes_;

  long lookaheadChoicePointsOfBodyNodes_;
  long lookaheadChoicePointsOfHeadNodes_;
  long lookaheadChoicesOfBodyNodes_;
  long lookaheadChoicesOfHeadNodes_;
  long lookaheadAssignmentsOfBodyNodes_;
  long lookaheadAssignmentsOfHeadNodes_;

  bool lookahead_;

  typedef std::map<std::string, long> OperatorMap;
  typedef OperatorMap::const_iterator OperatorMapIterator;
  OperatorMap operatorCounter_;
  event::Channel<OperatorStarted>* opChannel_;
};

}

#endif
