/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <heuristics/neg_arcs_count.h>
#include <head_node.h>
#include <body_node.h>
namespace NS_NOMORE {


void NegativeWeightArcsCountStrat::Evaluate::operator()(BodyNode* n) const {
  ValueType res(0, n->countNegBodyAtoms());
  for(BodyNode::HeadNodeIterator it = n->successorsBegin(); it != n->successorsEnd(); ++it)
    res.negSuccessors_ += (*it)->countOneSuccesors();

  n->installValue(new ValueHolder<ValueType>(res));
}

}
