/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <operators/forward_prop.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <algorithm>
#include <vector>
#include <iterator>
#ifdef KDEVELOP
  #include "functors.h"
#else
  #include "../detail/functors.h"
#endif

namespace NS_NOMORE {

ForwardPropagator::ForwardPropagator(Graph& grp) 
  : GraphOperator(ForwardPropagator::getOpName(), grp) {
  event::ChannelManager &em = grp.getEventManager();

  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);

}
ForwardPropagator::~ForwardPropagator() {
}
bool ForwardPropagator::execute() {
  bool keepRunning = false;
  bool changed = false;

  do {
    keepRunning  = propagateHeadNodes();
    keepRunning |= propagateBodyNodes();

    changed |= keepRunning;

  } while(keepRunning);

  return changed;
}

bool ForwardPropagator::propagateHeadNodes() {
  if(headNodes_.empty())
    return false;

  bool value = false;

  while(!headNodes_.empty()) {
    HeadNodeInfo headInfo = headNodes_.front();
    headNodes_.pop();
    
    if(headInfo.second == Color::plus || headInfo.second == Color::weak_plus) {
      value |= getGraph().color(*headInfo.first, headInfo.second);
    }
    else if(headInfo.first->isUnsupported()) {
      value |= getGraph().color(*headInfo.first, Color::minus);
    }
  }

  return value;
}
 

bool ForwardPropagator::propagateBodyNodes() {
  if(bodyNodes_.empty())
    return false;

  bool value = false;

  while(!bodyNodes_.empty()) {
    BodyNode* body = bodyNodes_.front();
    bodyNodes_.pop();

    if(body->getColor() != Color::ignore) {
      if(body->isBlocked() || body->isUnsupported()) {
        value |= getGraph().color(*body, Color::minus);
      }
      else if(body->isWeakSupported() && body->isUnblocked()) {
        Color::ColorValue col = body->isSupported() ? Color::plus : Color::weak_plus;
        value |= getGraph().color(*body, col);
      }
    }
  }

  return value;
}

void ForwardPropagator::handle(const HeadNodeColored& e) {
	addHeadSuccessors(*e.node_);
}

void ForwardPropagator::handle(const BodyNodeColored& e) {
	addBodySuccessors(*e.node_);
}

void ForwardPropagator::handle(const HeadNodeColoredChoicePoint& e) {
	addHeadSuccessors(*e.node_);
}

void ForwardPropagator::handle(const BodyNodeColoredChoicePoint& e) {
	addBodySuccessors(*e.node_);
}

void ForwardPropagator::addHeadSuccessors(const HeadNode& n) {
	std::copy(n.zeroSuccessorsBegin(), n.zeroSuccessorsEnd(),
		DETAIL::pushInserter(bodyNodes_));

	std::copy(n.oneSuccessorsBegin(), n.oneSuccessorsEnd(),
		DETAIL::pushInserter(bodyNodes_));
}

void ForwardPropagator::addBodySuccessors(const BodyNode& n) {
	BodyNode::HeadNodeIterator end = n.successorsEnd();
	for (BodyNode::HeadNodeIterator it = n.successorsBegin(); it != end; ++it)	{
		headNodes_.push(HeadNodeInfo(*it, n.getColor()));
	}
}

void ForwardPropagator::postExecute() {
  while(!headNodes_.empty()) { headNodes_.pop(); }
  while(!bodyNodes_.empty()) { bodyNodes_.pop(); }
}

bool ForwardPropagator::validate(const OpSet&) const {
  return true;
}

}
