#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <operators/body_lookahead.h>
#include <operators/forward_prop.h>
#include <graph.h>
#include <head_node.h>
#include <body_node.h>
#include <generic_value.h>

using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class BodyLookaheadProp : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(BodyLookaheadProp);
  CPPUNIT_TEST(testSuccess);
  CPPUNIT_TEST(testException);
  CPPUNIT_TEST(testFailure1);
  CPPUNIT_TEST_SUITE_END();

public:
  void handle(const BodyLookahead::EventType& e) {
    e.node_->installValue(new ValueHolder<BodyLookahead::ResultType>(e.value_));
  }
  void setUp() {
    grp = new Graph();

    body1 = grp->insertBodyNode();
    body2 = grp->insertBodyNode();
    body3 = grp->insertBodyNode();
    head1 = grp->insertHeadNode(1);
    head2 = grp->insertHeadNode(2);

    det = new ForwardPropagator(*grp);
    lookahead = new BodyLookahead(*grp, *det);
    grp->getEventManager().getChannelFor(event::Event<BodyLookahead::EventType>()).connect(*this);
  }

  void tearDown() {
    delete lookahead;
    delete det;
    delete grp;
  }

  void testSuccess() {
    body1->insertSuccessor(*head1);
    body1->insertSuccessor(*head2);
    head2->insertZeroSuccessor(*body2);
    head2->insertOneSuccessor(*body3);    
    
    (*lookahead)();

    CPPUNIT_ASSERT_EQUAL( true, body1->getValue() != 0 );
    CPPUNIT_ASSERT_EQUAL( true, body2->getValue() != 0 );
    CPPUNIT_ASSERT_EQUAL( true, body3->getValue() != 0 );
    CPPUNIT_ASSERT_EQUAL( false, head1->getValue() != 0 );
    CPPUNIT_ASSERT_EQUAL( false, head2->getValue() != 0 );
    CPPUNIT_ASSERT_EQUAL( 1l, value_cast<BodyLookahead::ResultType>(body1->getValue()).max_ );
    CPPUNIT_ASSERT_EQUAL( 1l, value_cast<BodyLookahead::ResultType>(body1->getValue()).min_ );
    CPPUNIT_ASSERT_EQUAL( 0l, value_cast<BodyLookahead::ResultType>(body2->getValue()).max_ );
    CPPUNIT_ASSERT_EQUAL( 0l, value_cast<BodyLookahead::ResultType>(body2->getValue()).min_ );
    CPPUNIT_ASSERT_EQUAL( 0l, value_cast<BodyLookahead::ResultType>(body3->getValue()).max_ );
    CPPUNIT_ASSERT_EQUAL( 0l, value_cast<BodyLookahead::ResultType>(body3->getValue()).min_ );

    CPPUNIT_ASSERT_EQUAL( Color::none, body1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::none, body2->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::none, body3->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::none, head1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::none, head2->getColor() );
  }

  void testException() {
    HeadNode *head3 = grp->insertHeadNode(3);
  
    body1->insertSuccessor(*head1);
    body1->insertSuccessor(*head2);
    head2->insertZeroSuccessor(*body2);
    head2->insertOneSuccessor(*body3);    
    body3->insertSuccessor(*head3);
    head3->insertZeroSuccessor(*body1);
    
    CPPUNIT_ASSERT_THROW( (*lookahead)(), ColorError );
  }

  void testFailure1() {    
    body1->insertSuccessor(*head1);
    head1->insertZeroSuccessor(*body2);
    body2->insertSuccessor(*head2);
    head2->insertOneSuccessor(*body2);
    
    grp->color(*head2, Color::minus);
    grp->color(*body2, Color::minus);
    
    (*lookahead)();

    CPPUNIT_ASSERT_EQUAL( Color::minus, body1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, body2->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, head1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, head2->getColor() );
  }
  
private:
  Graph *grp;

  Operator *det;
  BodyLookahead *lookahead;

  BodyNode *body1;
  BodyNode *body2;
  BodyNode *body3;
  HeadNode *head1;
  HeadNode *head2;
};

CPPUNIT_TEST_SUITE_REGISTRATION(BodyLookaheadProp);

} // end namespace NS_NOMORE_TESTS
