//
//  ProgramOptions
//  (C) Copyright Benjamin Kaufmann, 2004 - 2005
//	Permission to copy, use, modify, sell and distribute this software is 
//	granted provided this copyright notice appears in all copies. 
//	This software is provided "as is" without express or implied warranty, 
//	and with no claim as to its suitability for any purpose.
//
//  ProgramOptions is a scaled-down version of boost::program_options
//  see: http://boost-sandbox.sourceforge.net/program_options/html/
// 
#include "value.h"
#include <algorithm>
#include <sstream>
#include <cctype>
using namespace std;
namespace ProgramOptions {

namespace {
    inline char toLower(char c) {
        return tolower(static_cast<unsigned char>(c));
    }
}
std::string checkSingleValue(const std::string& s, bool allowEmpty)
{
	if (s.empty() && !allowEmpty)
		throw ProgramOptions::BadValue("at least one value required");
	if (s.find_first_of("\t\n ") != string::npos)
		throw ProgramOptions::BadValue("multiple values not allowed");
	return s;
}

void parseValue(const std::string& s, bool& b, int)
{
	string copy = checkSingleValue(s, true);
	transform(copy.begin(), copy.end(), copy.begin(), toLower);
	if (copy.empty() || copy == "true" || copy == "1" || copy == "yes" || copy == "on")
	{
		b = true;
	}
	else if (copy == "false" || copy == "0" || copy == "no" || copy == "off")
	{
		b = false;
	}
	else
		throw BadValue(std::string("value '") + s + "' is not a valid bool value");
}

void parseValue(const std::string& s, std::string& r, int)
{
	r = s;
}

void parseValue(const std::string& s, char& r, int)
{
	std::string temp = checkSingleValue(s, true);
	if (temp.length() > 1)
	{
		throw BadValue(std::string("value '") + s + "' is not a valid char");
	}
	r = temp[0];
}


Value<bool>* bool_switch(bool* b)
{
	Value<bool>* nv = new Value<bool>(b);
	nv->setImplicit();
	return nv;
}
}
