/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_HYBRID_LOOKAHEAD_HEURISTIC_H
#define LIBNOMORE_HYBRID_LOOKAHEAD_HEURISTIC_H
#include <operators/hybrid_lookahead.h>
#include <lookahead_heuristic.h>

namespace NS_NOMORE {

//! Heuristic-Strategy that compares two nodes based on the heuristic values generated by the HybridLookahead operator
/*! The result of the HybridLookahead operator is a long-value.
 *  This Strategy prefers the node with the greates value.
 *  The heuristic works for head and body nodes.
 *
 *  \note This strategy may be used only with an operator-based heuristic.
 *  \note If you want to use this strategy make sure that you also use the HybridLookahead-Operator.
 *
 *  \see HybridLookaheadHeuristic
 *  \see OperatorBasedHeuristic
 */
class HybridLookaheadHeuristicStrat {
public:
  typedef HybridLAHeuristicBase BaseType;
  typedef BaseType::HeuristicValueType ValueType;
  typedef std::greater<ValueType> ComparatorType;
};

typedef LookaheadHeuristic<HybridLookaheadHeuristicStrat> HybridLookaheadHeuristic;
}
#endif
