/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_OPERATOR_DECORATOR_FACTORY_H
#define LIBNOMORE_OPERATOR_DECORATOR_FACTORY_H

namespace NS_NOMORE {
class Operator;

//! Interface for classes that create operator decorators
class OperatorDecoratorFactory {
public:
  virtual ~OperatorDecoratorFactory();
  
  //! returns a decorator for the given operator
  /*!
   * the default implementation returns op, i.e. is a "null-object" implementation.
   */
  virtual Operator* decorate(Operator* op);
};

}
#endif
