/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_NULL_OPERATOR_H
#define NOMORE_NULL_OPERATOR_H

#include <operator.h>
#include <color.h>

#include <queue>
#include <utility>

namespace NS_NOMORE {

//! This operator does nothing and can be used as null object.
/*! 
 * \see The Null Object Pattern http://c2.com/cgi/wiki?NullObject
 * 
 */
class NullOperator : public Operator {
public:
  NullOperator();
  //! Creates the operator.
  explicit NullOperator(Graph& grp);

  //! Returns the name of the operator.
  static std::string getOpName() {
    return "Null";
  }

  //! always returns ColorOperation::unchanged
  ColorOpResult operator()();
};

}

#endif
