/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_STD_STATS_H
#define LIBNOMORE_STD_STATS_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <iosfwd>
#include <stats.h>
#include <map>
#include <string>
#include <event/channel.h>
namespace NS_NOMORE {

class Graph;
struct HeadNodeColored;
struct BodyNodeColored;
struct BodyNodeColoredChoicePoint;
struct HeadNodeColoredChoicePoint;
struct LookaheadExecution;

//! This class gathers some important statistic values like choice points or assignments.
/*!
 * Use this class together with an \ref ObjectFactory "object factory" to let
 * it decorate operators with an \ref InvocationDecorator "invocation decorator".
 * This way this class can gather information about the executed
 * operators (number of executions and names).
 */
class StdStatistics : public Statistics {
public:
  //! Constructs the stats instance.
  StdStatistics();

  //! Returns the number of nodes that were colored as choice points
  long countChoicePoints() const {
    return (choicePoints_);
  }  

  //! Returns the number of choices (i.e. the number of choice points that were recolored)
  long countChoices() const {
    return (choices_);
  }  

  //! Returns the number of assignments (i.e. the number of times a color was assigned to a node).
  long countAssignments() const {
    return assignments_;
  }

  //! Returns the number of nodes tested in lookahead.
  long countLookaheadCheckNodes() const {
    return (lookaheadChoicePoints_);
  }  

  //! Returns the number of nodes tested in lookahead.
  long countLookaheadChoiceNodes() const {
    return (lookaheadChoices_);
  }  
  
  //! Returns the number of assignments in lookahead.
  long countLookaheadAssignments() const {
    return lookaheadAssignments_;
  }
  
  void registerWith(event::ChannelManager& m);

  //! event handler for HeadNodeColored events.
  void handle(const HeadNodeColored& e);

  //! event handler for BodyNodeColored events.
  void handle(const BodyNodeColored& e);

  //! event handler for BodyNodeColoredChoicePoint events
  void handle(const BodyNodeColoredChoicePoint& e);

  //! event handler for HeadNodeColoredChoicePoint events
  void handle(const HeadNodeColoredChoicePoint& e);

  //! event handler for LookaheadExecution events
  void handle(const LookaheadExecution& e);

  void printReport(std::ostream& os) const;
  
private:
  long choicePoints_;
  long choices_;
  long assignments_;

  long lookaheadChoicePoints_;
  long lookaheadChoices_;
  long lookaheadAssignments_;

  bool lookahead_;
};

}

#endif
