/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <heuristics/static_lex_ordering.h>
#include <head_node.h>
#include <body_node.h>
#include <vector>
#include <iterator>
#include <algorithm>
#include "../src/detail/functors.h"
#if defined (_MSC_VER) && _MSC_VER <= 1300
#define for if(0); else for
#endif

using  namespace std;
namespace NS_NOMORE {
  

StaticLexOrderingStrat::ValueType StaticLexOrderingStrat::Evaluate::operator()(Node* n) const {
  if (n->getType() == NodeType::body_node) {
    BodyNode* bn = static_cast<BodyNode*>(n);
    std::vector<HeadNode*> zero;
    copy(bn->zeroPredecessorsBegin(), bn->zeroPredecessorsEnd(), back_inserter(zero));
    sort(zero.begin(), zero.end(), DETAIL::LessLexOrderHeadPtr());

    ValueType p;
    for(BodyNode::HeadNodeIterator it = zero.begin(); it != zero.end(); ++it) {
      p.first += (*it)->getAtomName() + " ";
    }

    std::vector<HeadNode*> one;
    copy(bn->onePredecessorsBegin(), bn->onePredecessorsEnd(), back_inserter(one));
    sort(one.begin(), one.end(), DETAIL::LessLexOrderHeadPtr());

    for(BodyNode::HeadNodeIterator it = one.begin(); it != one.end(); ++it) {
      p.second += (*it)->getAtomName() + " ";
    }
    return p;
  }
  else {
    assert(n->getType() == NodeType::head_node);
    return ValueType(static_cast<HeadNode*>(n)->getAtomName(), "");
  }
}


}
