/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <operators/forward_prop.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>

namespace NS_NOMORE { namespace {

///////////////////////////////////////////////////////////////////////////////
bool propagateHeadSuccessors(Graph& g, HeadNode::BodyNodeIterator it, HeadNode::BodyNodeIterator end) {

  bool error = false;  
  for (; it != end && !error; ++it) {
    if((*it)->getColor() != Color::ignore) {
      if((*it)->isBlocked() || (*it)->isUnsupported()) {
        error = g.color(**it, Color::minus) == false;
      }
      else if( (*it)->isWeakSupported() && (*it)->isUnblocked() ) {
        error = g.color(**it, (*it)->recursiveSupportColor()) == false;
      }
    }
  }

  return error;
}

inline bool propagateBodySuccessors(Graph& g, BodyNode* b, BodyNode::HeadNodeIterator it, BodyNode::HeadNodeIterator end) {
  bool error = false;
  for (; it != end && !error; ++it) {
    if (b->getColor() == Color::plus || b->getColor() == Color::weak_plus) {
      error = !g.color(**it, b->getColor());
    }
    else if ( (*it)->isUnsupported() ) {
      error = !g.color(**it, Color::minus);
    }
  }
  return error;
}

} // end anonymous-namespace
///////////////////////////////////////////////////////////////////////////////

ForwardPropagator::ForwardPropagator(Graph& grp) 
  : PropOperator(ForwardPropagator::getOpName(), grp) {
  event::ChannelManager &em = grp.getEventManager();

  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);

}
ForwardPropagator::~ForwardPropagator() {
}


void ForwardPropagator::execute() {
  
  for (Graph& g = getGraph(); !g.hasConflict() && (!headsChanged_.empty() || !bodiesChanged_.empty()); ) {
    propagateHeadNodes() ||
    propagateBodyNodes();
  }

}

bool ForwardPropagator::propagateHeadNodes() {
  Graph& g = getGraph();
  for (HeadNode* n = 0; !headsChanged_.empty() && !g.hasConflict(); headsChanged_.pop()) {
    n = headsChanged_.front();
    assert(n);
    propagateHeadSuccessors(g, n->zeroSuccessorsBegin(), n->zeroSuccessorsEnd()) ||
    propagateHeadSuccessors(g, n->oneSuccessorsBegin(), n->oneSuccessorsEnd());
  }

  return g.hasConflict();
}
 

bool ForwardPropagator::propagateBodyNodes() {
  Graph& g = getGraph();
  for (BodyNode* n = 0; !bodiesChanged_.empty() && !g.hasConflict(); bodiesChanged_.pop()) {
    n = bodiesChanged_.front();
    assert(n);
    propagateBodySuccessors(g, n, n->successorsBegin(), n->successorsEnd());
  }
  
  return g.hasConflict();
}


void ForwardPropagator::handle(const HeadNodeColored& e) {
  headsChanged_.push(e.node_);
}

void ForwardPropagator::handle(const BodyNodeColored& e) {
  bodiesChanged_.push(e.node_);
}

void ForwardPropagator::handle(const HeadNodeColoredChoicePoint& e) {
  headsChanged_.push(e.node_);
  
}

void ForwardPropagator::handle(const BodyNodeColoredChoicePoint& e) {
  bodiesChanged_.push(e.node_);
}


void ForwardPropagator::reset() {
  
  while (!headsChanged_.empty()) 
    headsChanged_.pop();
  while (!bodiesChanged_.empty()) 
    bodiesChanged_.pop();
  
}

}
