/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/hybrid_lookahead.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <constraint.h>
#include <heuristic.h>

namespace NS_NOMORE {
HybridLookahead::HybridLookahead(Graph& grp, Operator& op, const Constraint& con, Heuristic& heu) 
  : Lookahead(HybridLookahead::getOpName(), grp, op, con)
  , currentNode_(0)
  , currentValue_(0) {
  setHeuristic(heu);
}

HybridLookahead::HybridLookahead(Graph& grp) 
  : Lookahead(HybridLookahead::getOpName(), grp)
  , currentNode_(0)
  , currentValue_(0)
  , heuristic_(0) {
}


void HybridLookahead::execute() {
  
  event::ChannelManager &em = getGraph().getEventManager();
  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);

  bool repeat = false;
  Graph& g = getGraph();
  do {
    repeat = false;
    Graph::UncoloredNodeIterator end = g.uncoloredNodesEnd();
    for (Graph::UncoloredNodeIterator it = g.uncoloredNodesBegin(); it != end; ++it) {
      currentNode_ = *it;
      if (checkCurrentNode()) {
        if ( !g.hasConflict() ) {
          repeat = true;
        }
        else {
          repeat = false;
          break;
        }
      }
    }
  } while (repeat);

  em.getChannelFor(event::Event<HeadNodeColored>()).disconnect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).disconnect(*this);  
  em.getChannelFor(event::Event<BodyNodeColored>()).disconnect(*this);
  lookaheadInfos_.clear();
}

void HybridLookahead::handle(const HeadNodeColored& e) {
  if(e.node_->oneSuccessorsBegin() != e.node_->oneSuccessorsEnd())
    ++currentValue_;

  if(e.node_->getColor() == Color::minus && getConstraint().supersedes(*currentNode_, *e.node_)) {
    lookaheadInfos_.insert(e.node_->getId());
  }
}

void HybridLookahead::handle(const HeadNodeColoredChoicePoint& e) {
  if(e.node_->oneSuccessorsBegin() != e.node_->oneSuccessorsEnd())
    ++currentValue_;
}

void HybridLookahead::handle(const BodyNodeColored& e) {
  if (HasColor(Color::plus | Color::weak_plus)(e.node_)
    && getConstraint().supersedes(*currentNode_, *e.node_)) {
    lookaheadInfos_.insert(e.node_->getId());
  }
}

void HybridLookahead::resetCounter() {
  currentValue_ = 0;
}

void HybridLookahead::storeHeuristic() {
  if (heuristic_) {
    heuristic_->addHeuristicValue(currentNode_, currentValue_);
  }
}

bool HybridLookahead::checkCurrentNode() {
  if(lookaheadInfos_.find(currentNode_->getId()) != lookaheadInfos_.end())
    return false;
  
  resetCounter();
  if (checkColor(*currentNode_, currentNode_->preferredChoicePointColor())) {
    storeHeuristic();    
    return false;
  }
  else {
    // conflict found
    color(*currentNode_, currentNode_->alternativeChoicePointColor());    
    // reset the info map (all nodes must be re-checked)
    lookaheadInfos_.clear();
    return true;
  }
}

void HybridLookahead::setHeuristic(Heuristic& h) {
  heuristic_ = dynamic_cast<HybridLAHeuristicBase*>(&h);
}

}
