/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <statistics/full_statistic.h>
#include <operators/lookahead.h>
#include <head_node.h>
#include <body_node.h>
#include <event/channel_manager.h>
#include <ostream>

namespace NS_NOMORE {

FullStatistics::FullStatistics() 
  : Statistics()
  , choicePointsOfBodyNodes_(0)
  , choicePointsOfHeadNodes_(0)
  , choicesOfBodyNodes_(0)
  , choicesOfHeadNodes_(0)
  , assignmentsOfBodyNodes_(0)
  , assignmentsOfHeadNodes_(0)
  , lookaheadChoicePointsOfBodyNodes_(0)
  , lookaheadChoicePointsOfHeadNodes_(0)
  , lookaheadChoicesOfBodyNodes_(0)
  , lookaheadChoicesOfHeadNodes_(0)
  , lookaheadAssignmentsOfBodyNodes_(0)
  , lookaheadAssignmentsOfHeadNodes_(0) 
  , lookaheadDecidedBodyNodes_(0)
  , lookaheadDecidedHeadNodes_(0)
  , lookahead_(false) {
}

void FullStatistics::registerWith(event::ChannelManager& m) {
  m.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  m.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  m.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).connect(*this);
  m.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
  m.getChannelFor(event::Event<LookaheadExecution>()).connect(*this);
}
void FullStatistics::handle(const HeadNodeColored&) {
  if(lookahead_)
    lookaheadAssignmentsOfHeadNodes_++;
  else
    assignmentsOfHeadNodes_++;
}

void FullStatistics::handle(const BodyNodeColored&) {
  if(lookahead_)
    lookaheadAssignmentsOfBodyNodes_++;
  else
    assignmentsOfBodyNodes_++;
}

void FullStatistics::handle(const BodyNodeColoredChoicePoint& e) {
  if(lookahead_) {
    lookaheadAssignmentsOfBodyNodes_++;
    lookaheadChoicesOfBodyNodes_++;
    if(!e.recolored_)      
      lookaheadChoicePointsOfBodyNodes_++;
    else
      lookaheadDecidedBodyNodes_++;
  } else {
    assignmentsOfBodyNodes_++;
    choicesOfBodyNodes_++;
    if(!e.recolored_)
      choicePointsOfBodyNodes_++;
  }
}

void FullStatistics::handle(const HeadNodeColoredChoicePoint& e) {
  if(lookahead_) {
    lookaheadAssignmentsOfHeadNodes_++;
    lookaheadChoicesOfHeadNodes_++;
    if(!e.recolored_)
      lookaheadChoicePointsOfHeadNodes_++;
    else
      lookaheadDecidedHeadNodes_++;
  } else {
    assignmentsOfHeadNodes_++;
    choicesOfHeadNodes_++;
    if(!e.recolored_)
      choicePointsOfHeadNodes_++;
  }
}

void FullStatistics::handle(const LookaheadExecution& e) {
  if(e.state_ == ActivityState::started)
    lookahead_ = true;
  else if(e.state_ == ActivityState::finished)
    lookahead_ = false;
}

void FullStatistics::onOperatorStarted(const std::string& name) {
  ++operatorCounter_[name];
}

void FullStatistics::printReport(std::ostream& os) const {
  printTimer(os);

  os << "Choices: " << countChoices() 
     << " (" << countChoicesOfHeadNodes() << " heads, " 
     << countChoicesOfBodyNodes() << " bodies)\n"

     << "Choice Points: " << countChoicePoints() 
     << " (" << countChoicePointsOfHeadNodes() << " heads, "
     << countChoicePointsOfBodyNodes() << " bodies)\n"

     << "Assignments: " << countAssignments() 
     << " (" << countAssignmentsOfHeadNodes() << " heads, "
     << countAssignmentsOfBodyNodes() << " bodies)\n";
    
  if(countLookaheadCheckedNodes() != 0) {
    os << "Check Nodes in Lookahead: " << countLookaheadCheckedNodes() 
      << " (" << countLookaheadCheckedHeadNodes() << " heads, " 
      << countLookaheadCheckedBodyNodes() << " bodies)\n"

      << "Decided Nodes in Lookahead: " << countDecidedNodesInLookahead() 
      << " (" << countDecidedHeadNodesInLookahead() << " heads, "
      << countDecidedBodyNodesInLookahead() << " bodies)\n"

      << "Assignments in Lookahead: " << countLookaheadAssignments() 
      << " (" << countLookaheadAssignmentsOfHeadNodes() << " heads, "
      << countLookaheadAssignmentsOfBodyNodes() << " bodies)\n";
  }

  for(OperatorMapIterator it = operatorCounter_.begin(); it != operatorCounter_.end(); ++it) {
    os << "Calls to " << it->first << ": " << it->second << "\n";
  }
}

Operator* FullStatistics::decorate(Operator* op) {
  return new InvocationDecorator(op, this);
}

long FullStatistics::countOperatorCalls(const std::string& op) {
  return operatorCounter_[op];
}

}

