/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <statistics/std_statistic.h>
#include <operators/lookahead.h>
#include <head_node.h>
#include <body_node.h>
#include <event/channel_manager.h>
#include <ostream>

namespace NS_NOMORE {

StdStatistics::StdStatistics() 
  : Statistics()
  , choicePoints_(0)
  , choices_(0)
  , assignments_(0)
  , lookaheadChoicePoints_(0)
  , lookaheadChoices_(0)
  , lookaheadAssignments_(0)
  , lookahead_(false) {
}

void StdStatistics::registerWith(event::ChannelManager& m) {
  m.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  m.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  m.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).connect(*this);
  m.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
  m.getChannelFor(event::Event<LookaheadExecution>()).connect(*this);
}
void StdStatistics::handle(const HeadNodeColored&) {
  if(lookahead_)
    lookaheadAssignments_++;
  else
    assignments_++;
}

void StdStatistics::handle(const BodyNodeColored&) {
  if(lookahead_)
    lookaheadAssignments_++;
  else
    assignments_++;
}

void StdStatistics::handle(const BodyNodeColoredChoicePoint& e) {
  if(lookahead_) {
    lookaheadAssignments_++;
    lookaheadChoices_++;
    if(!e.recolored_)      
      lookaheadChoicePoints_++;
  } else {
    assignments_++;
    choices_++;
    if(!e.recolored_)
      choicePoints_++;
  }
}

void StdStatistics::handle(const HeadNodeColoredChoicePoint& e) {
  if(lookahead_) {
    lookaheadAssignments_++;
    lookaheadChoices_++;
    if(!e.recolored_)
      lookaheadChoicePoints_++;
  } else {
    assignments_++;
    choices_++;
    if(!e.recolored_)
      choicePoints_++;
  }
}

void StdStatistics::handle(const LookaheadExecution& e) {
  if(e.state_ == ActivityState::started)
    lookahead_ = true;
  else if(e.state_ == ActivityState::finished)
    lookahead_ = false;
}

void StdStatistics::printReport(std::ostream& os) const {
  printTimer(os);
  os << "Choices: " << countChoices() << "\n"
     << "Choice Points: " << countChoicePoints() << "\n";
  os << "Assignments: " << countAssignments();
}

}

