/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         *
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         *
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <strong_components.h>
#include <graph.h>
#include <head_node.h>
#include <body_node.h>
#include <vector>
#include <stack>

namespace NS_NOMORE { namespace {

class StrongComponentFinder
{
public:
	StrongComponentFinder(Graph& g)
		: graph_(g)
		, pre_(g.countNodes(), -1)
		, low_(g.countNodes(), 0)
		, strongComponents_(0)
		, count_(0) {
	}
  int identifyStrongComponents() {
    size_t maxNode = graph_.countNodes();
    for (size_t i = 0; i != maxNode; ++i) {
      if (pre_[i] == -1)
        checkForStrongComponent(graph_.getNode(i));
    }
    return strongComponents_;
  }
private:
	Graph& graph_;
  std::vector<int> pre_, low_;
	std::stack<Node*> stack_;
  typedef std::vector<int>::size_type size_t;
	int strongComponents_;
	int count_;

  void checkForStrongComponent(Node* node) {
    stack_.push(node);
    long nodeId = node->getId();
    int min = low_[nodeId] = pre_[nodeId] = count_++;
    if (node->getType() == NodeType::head_node) {
      processSuccs(static_cast<HeadNode*>(node), min);
    }
    else {
      assert(node->getType() == NodeType::body_node);
      processSuccs(static_cast<BodyNode*>(node), min);
    }
    if (min < low_[nodeId]) {
			low_[ nodeId] = min;

		}
		else {
			size_t maxVertex = graph_.countNodes();
      Node* succVertex = 0;
			do {
				succVertex = stack_.top();
				stack_.pop();
				succVertex->setComponentNumber(strongComponents_);
				low_[succVertex->getId()] = maxVertex;
			} while(succVertex != node);
			++strongComponents_;
		}
    
  }
  
  void processSuccs(HeadNode* n, int& min) {
    HeadNode::BodyNodeIterator it = n->zeroSuccessorsBegin();
    HeadNode::BodyNodeIterator end = n->zeroSuccessorsEnd();
    for (; it != end; ++it) {
      processSucc(*it, min);
    }
  }

  void processSuccs(BodyNode* n, int& min) {
    BodyNode::HeadNodeIterator it = n->successorsBegin();
    BodyNode::HeadNodeIterator end = n->successorsEnd();
    for (; it != end; ++it) {
      processSucc(*it, min);
    }
  }

  void processSucc(Node* n, int& min) {
    long succId = n->getId();
    if (pre_[succId] == -1) {
        checkForStrongComponent(n);
    }
    if (low_[succId] < min) {
				min = low_[succId];
    }
  }

};

}   // end anonymous-namespace

int identifyStrongComponents(Graph& g) {
  StrongComponentFinder f(g);
  int sc = f.identifyStrongComponents();
  return sc != g.countNodes() ? sc : 0;
}

} // end namepsace NS_NOMORE
