/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_LEX_ORDERING_HEURISTIC_H
#define LIBNOMORE_LEX_ORDERING_HEURISTIC_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <string>
#include <utility>
#include <static_heuristic.h>
namespace NS_NOMORE {

//! Heuristic-Strategy that values nodes based on their lexicographical ordering.
/*! This class is useful for testing.
 * Using this Strategy a body b1 is better than a body b2:
 *  -# iff the positive part represented as an ordered string of atom names of b1 
 *  precedes the positive part of b2
 *  -# or if the positive parts of b1 and b2 are equal 
 *     iff the negative part represented as an ordered string of atom names of b1 
 *      precedes the negative part of b2.
 *  -# a head node h1 is better than another head node h2 iff the atom name of h1 
 *     lexicographically prcedes the atom name of h2.
 *
 */
class StaticLexOrderingStrat {
public:
  typedef std::pair<std::string, std::string> ValueType;
  struct Compare {
    bool operator()(const ValueType& v1, const ValueType& v2) const {
      return v1.first < v2.first || (v1.first == v2.first && v1.second < v2.second);
    }
  };
  struct Evaluate {
    ValueType operator()(Node*, double tf) const;
  };

  typedef Compare ComparatorType;
  typedef Evaluate EvaluatorType;
};

//! A static heuristic that uses StaticLexOrderingStrat as strategy.
typedef StaticHeuristic<StaticLexOrderingStrat> LexOrdering;

}
#endif
