/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_SELECT_SUPPORTED_OPERATOR_H
#define NOMORE_SELECT_SUPPORTED_OPERATOR_H

#include <choice_operator.h>
#include <heuristic.h>

namespace NS_NOMORE {

//! Choice operator that selects uncolored body nodes that are supported.
/*! This operator implements the support-driven choice operator which selects the 
 *  first supported and uncolored body node.
 *  \see ChoiceOperator
 */
class SelectSupported : public ChoiceOperator, public Constraint {
public:
  //! Creates the choice operator.
  /*! \param grp The graph the operator should work on. */ 
  SelectSupported(Graph& grp, Heuristic* h);

  Choice selectChoice();

  
  virtual bool supersedes(const Node& n1, const Node& n2) const;

  Constraint::Type getType() const;

  //! Returns the name of the operator.
  const char* getName() const;

  virtual const Constraint& getConstraint() const {
    return *this;
  }
private:
  //! Returns true if n is a body node that is uncolored and supported
  virtual bool isSatisfiedBy(const Node& n) const;

};

}

#endif
