/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/body_lookahead.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <constraint.h>
#include <heuristic.h>

namespace NS_NOMORE {


///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(BodyLookahead*) {
  return "BLA";
}

template <>
Lookahead* createLookaheadOp(Graph& g, BodyLookahead*) {
  return new BodyLookahead(g);
}
///////////////////////////////////////////////////////////////////////////////

  
BodyLookahead::BodyLookahead(Graph& grp, Operator& op, const Constraint& con, Heuristic& heu) 
  : Lookahead(grp, op, con)
  , heuristic_(0)
  , counterPlus_(0)
  , counterMinus_(0)
  , lookaheadNode_(0) {

  setHeuristic(heu);
  grp.checkTightness();
  
}

BodyLookahead::BodyLookahead(Graph& grp) 
  : Lookahead(grp)
  , heuristic_(0)
  , counterPlus_(0)
  , counterMinus_(0)
  , lookaheadNode_(0) {
  grp.checkTightness();
}

const char* BodyLookahead::getName() const {
  return NS_NOMORE::getName<BodyLookahead>(0);
}

void BodyLookahead::execute() {
  
  event::ChannelManager &em = getGraph().getEventManager();
  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);

  bool repeat = false;
  Graph& g = getGraph();
  do {
    repeat = false;
    Graph::UncoloredNodeIterator end = g.uncoloredNodesEnd();
    for (Graph::UncoloredNodeIterator it = g.uncoloredNodesBegin(); it != end; ++it) {
      lookaheadNode_ = *it;
      if (lookaheadNode_->getType() == NodeType::body_node && checkCurrentNode()) {
        if ( !g.hasConflict() ) {
          repeat = true;
        }
        else {
          repeat = false;
          break;
        }
      }
    }
  } while (repeat);
  

  em.getChannelFor(event::Event<HeadNodeColored>()).disconnect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).disconnect(*this);  
  em.getChannelFor(event::Event<BodyNodeColored>()).disconnect(*this);
  lookaheadPlusInfos_.clear();
  lookaheadMinusInfos_.clear();
}


void BodyLookahead::handle(const HeadNodeColored& e) {
  if(e.node_->oneSuccessorsBegin() != e.node_->oneSuccessorsEnd()) {
    lookaheadColorCheck_ == Color::plus ? ++counterPlus_ : ++counterMinus_;
  }    
}

void BodyLookahead::handle(const HeadNodeColoredChoicePoint& e) {
  if(e.node_->oneSuccessorsBegin() != e.node_->oneSuccessorsEnd()) {
    lookaheadColorCheck_ == Color::plus ? ++counterPlus_ : ++counterMinus_;
  } 
}

inline void BodyLookahead::updateLookaheadInfoMap(LookaheadInfoMap &infoMap, Node& node) {
  if(getConstraint().supersedes(*lookaheadNode_, node)) {
    infoMap.insert(node.getId());
  }
    
}

void BodyLookahead::handle(const BodyNodeColored& e) {
  if(e.node_->getColor() == Color::plus || e.node_->getColor() == Color::weak_plus) {
    updateLookaheadInfoMap(lookaheadPlusInfos_, *e.node_);
  }    
  else if(e.node_->getColor() == Color::minus) {
    updateLookaheadInfoMap(lookaheadMinusInfos_, *e.node_);
  }
}

void BodyLookahead::resetCounter() {
  counterPlus_ = 0;
  counterMinus_ = 0;
}

void BodyLookahead::storeHeuristic() {
  if (heuristic_) {
    double tf = getGraph().getTightnessFactor(lookaheadNode_);
    heuristic_->addHeuristicValue(
      lookaheadNode_, 
      HeuristicValueType(tf * counterPlus_, tf * counterMinus_)
    );
  }
}


bool BodyLookahead::checkCurrentNode() {

  bool conflict = false;
  resetCounter();
  LookaheadInfoMapIterator it = lookaheadPlusInfos_.find(lookaheadNode_->getId());
  if(it == lookaheadPlusInfos_.end()) {           
    lookaheadColorCheck_ = lookaheadNode_->preferredChoicePointColor();
    alternativeColor_ = lookaheadNode_->alternativeChoicePointColor();
    conflict = checkColor(*lookaheadNode_, lookaheadColorCheck_) == false;
  }

  it = lookaheadMinusInfos_.find(lookaheadNode_->getId());
  if(!conflict && it == lookaheadMinusInfos_.end()) {
    lookaheadColorCheck_ = lookaheadNode_->alternativeChoicePointColor();
    alternativeColor_ = lookaheadNode_->preferredChoicePointColor();      
    conflict = checkColor(*lookaheadNode_, lookaheadColorCheck_) == false;
  }
  if (!conflict) {
    storeHeuristic();
  }
  else {
    // conflict found
    color(*lookaheadNode_, alternativeColor_);    
    // reset the info map (all nodes must be re-checked)
    lookaheadPlusInfos_.clear();
    lookaheadMinusInfos_.clear();
    // conflict, but other way work
  }
  return conflict;
}

void BodyLookahead::setHeuristic(Heuristic& h) {
  heuristic_ = dynamic_cast<BodyLAHeuristicBase*>(&h);
}


}
