/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/post_operator.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
namespace NS_NOMORE {

///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(PostOperator*) {
  return "N";
}

template <>
Operator* createDetOp(Graph& g, PostOperator*) {
  return new PostOperator(g);
}
///////////////////////////////////////////////////////////////////////////////


PostOperator::PostOperator(Graph& grp) 
  : Operator(grp)
  , graph_(&grp) {
}

ColorOpResult PostOperator::operator()() {
  if (graph_->countWeakColoredNodes() != 0)
    return ColorOperation::failed;

  if (graph_->countUncoloredNodes()) {
    for (Graph::UncoloredNodeIterator it = graph_->uncoloredNodesBegin(); it != it.end(); ++it) {
      if (!graph_->color(**it, Color::minus))
        return ColorOperation::failed;
    }
    return ColorOperation::succeeded;
  }
  return ColorOperation::unchanged;
}


bool PostOperator::validate(const OpSet& ops) const {
  return ops.count("U") == 0;
}

const char* PostOperator::getName() const {
  return NS_NOMORE::getName<PostOperator>(0);
}

}
