/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/select_uncolored.h>
#include <operators/unfounded_set.h>
#include <graph.h>
#include <body_node.h>
#include <head_node.h>
namespace NS_NOMORE {

 ///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(SelectUncolored*) {
  return "C";
}

template <>
ChoiceOperator* createChoiceOp(Graph& g, Heuristic* h, SelectUncolored*) {
  return new SelectUncolored(g, h);
}
///////////////////////////////////////////////////////////////////////////////


SelectUncolored::SelectUncolored(Graph& grp, Heuristic* h) 
  : ChoiceOperator(grp, h) {
}

Constraint::Type SelectUncolored::getType() const {
  return Constraint::hybrid_constraint;
}

const char* SelectUncolored::getName() const {
  return "C";
}

Choice SelectUncolored::selectChoice() {
  return getHeuristic().selectNode(*this);
}

bool SelectUncolored::isSatisfiedBy(const Node& n) const{
  return n.getColor() == Color::none;
}


bool SelectUncolored::supersedes(const Node&, const Node&) const {
  return true;
}

}
