/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         *
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         *
 ***************************************************************************/

#ifndef NOMORE_MAX_SUPPORT_BY_EMPTY_PRECONDITIONS_OPERATOR_H
#define NOMORE_MAX_SUPPORT_BY_EMPTY_PRECONDITIONS_OPERATOR_H

#include <operator.h>
#include <color.h>
#include <util/hash_set.h>
#include <util/queue.h>
#include <vector>

namespace NS_NOMORE {

class HeadNode;
class BodyNode;
class Node;
struct HeadNodeColored;
struct BodyNodeColored;
struct GraphConstructionFinished;

//! Deprecated implementation of the U-Operator
/*!
 *  \deprecated This operator is deprecated. It will be removed in the next
 * release. Don't use this operator.
 *
 *  This operator represents the U-Operator of the noMoRe++ system which generates the
 *  maximal support graph. The maximal support contains all nodes which can be reached
 *  from nodes without positive preconditions (no 0-predecessors) over zero and
 *  unlabeled arcs.
 *  The partial coloring can be wrong.
 *
 *  Q: How does the operator work?<br>
 *  A: For the execution of this operator there are several steps necessary.
 *
 *  <b>Step 0 (only first execution):</b> Populate base-queue.<br>
 *  The first time this operator is executed it puts all body nodes having no
 *  zero-predecessors into a queue. From now on
 *  this queue serves as the basis for determing the canidate-set.
 *
 *  <b>Step 1:</b> Get candidates<br>
 *  The operator iterates through the base-queue and
 *  puts all plus and uncolored nodes into the candidate-set.
 *
 *  <b>Step 2:</b> Generate maximal support graph.<br>
 *  Add all nodes (of the graph) which are
 *  supported by other candidates to the candidate-set.
 *  - A body node is supported iff all of its zero-predecessors are contained in
 *    the candidate-set.
 *  - A head node is supported iff one predecessor is contained in the
 *    candidate-set.
 *
 *  <b>Step 3:</b> Color all nodes not in the candidate-set to minus.
 *
 * \par preconditions: \n
 *  The graph is finalized.
 *
 * \par <b>To which events does this operator listen?</b> \n
 * In order to fulfill its job this operator listens to the following events: \n
 *	- GraphConstructionFinished
 */
class OriginalUnfoundedSetOperator : public PropOperator {
public:
  //! Creates the operator.
  /*! \param grp The graph the operator should work on. */
  OriginalUnfoundedSetOperator(Graph& grp);

  //! Handles a GraphConstructionFinished event fired by the graph.
  void handle(const GraphConstructionFinished& e);

  //! Returns the name of the operator.
  const char* getName() const;

  //! returns true if ops contains neither U
  bool validate(const OpSet& ops) const;

private:

  void execute();

  //! Resets all members.
  virtual void reset();

  //! Checks if all 0-predecessors of the body node are contained in the reached node set.
  bool isSupported(const BodyNode& node);

  //! Checks if one predecessors of the head node are contained in the reached node set.
  bool isSupported(const HeadNode& node);

  //! Checks if the node with an identifier is in the reached set.
  bool isReached(long id);

  //! Puts all facts in the propagation queue.
  void initExecution();

  //! Propagates the maximal support graph.
  bool propagateHeadNodes();
  bool propagateBodyNodes();

  void addSuccessors(const HeadNode& node);
  void addSuccessors(const BodyNode& node);

  //! Colors all uncolored nodes which are not in reached set.
  void colorMaxUnsuppedBodyNode();
  void colorMaxUnsuppedHeadNode();

  typedef util::queue<HeadNode*> HeadNodeQueue;
  typedef util::queue<BodyNode*> BodyNodeQueue;

  /*! Head nodes queue. */
  HeadNodeQueue headNodes_;
  /*! Body nodes queue. */
  BodyNodeQueue bodyNodes_;

  typedef std::vector<HeadNode*> HeadNodeVector;
  typedef std::vector<BodyNode*> BodyNodeVector;
  /*! Facts. Nodes colored plus in the preprocessing step. */
  HeadNodeVector headNodeWithoutPositivePreconditions_;
  BodyNodeVector bodyNodeWithoutPositivePreconditions_;

  /*! The nodes which are reached in the current execution. */
  typedef util::hash_set<long> NodeIdSet;
  NodeIdSet reachedNodes_;
};

}

#endif
