/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_STDSET_PRINTER_H
#define NOMORE_STDSET_PRINTER_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#pragma warning (disable : 4503)
#endif

#include <printer.h>
#include <set>
#include <string>
namespace NS_NOMORE {

//! Prints the answer sets of the graph to a std::set.
/*! Use this class to print all plus colored head nodes (the name of the atoms 
 *  corresponding to the head node) to a std::set of std::set of strings. */
class StdSetPrinter : public Printer {
public:
  //! Set of all answers.
  typedef std::set<std::string> AnswerSet;

  //! Set of all answer sets.
  typedef std::set<AnswerSet> AllAnswerSets;

  //! Constructs the object.
  StdSetPrinter() {
  }

  
  //! Returns all answer sets.
  AllAnswerSets& getAnswerSets() {
    return _answerSets;
  }

private:
  //! Prints the answer set to std::set.
  void print(int nr, const Graph& g);

  AllAnswerSets _answerSets;
};

}

#endif
