/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_OPERATOR_CALL_STATS_H
#define LIBNOMORE_OPERATOR_CALL_STATS_H

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <statistics/statistics_object.h>
#include <statistics/invocation_decorator.h>
#include <operator_decorator_factory.h>
#include <map>

namespace NS_NOMORE {

//! This class gathers some important statistic values like choice points or assignments.
/*!
 *  Use this class together with an \ref ObjectFactory "object factory" to let
 *  it decorate operators with an \ref InvocationDecorator "invocation 
 *  decorator".
 *  This way this class can gather information about the executed
 *  operators (number of executions and names).
 */
class OperatorCalls : public StatisticsObject, public OperatorDecoratorFactory, public InvocationDecorator::Observer {

public:
  //! Constructs the stats instance.
  OperatorCalls(event::ChannelManager& m);

  //! Is called if an operator is started.
  void onOperatorStarted(const std::string& name);
    
  //! Prints the result of the information-gathering.
  void print(std::ostream& os) const;

  //! Decorates the operator with an invocation decorator.
  virtual Operator* decorate(Operator* op);

  long countOperatorCalls(const std::string& op) {
    return operatorCounter_[op];
  }

  //! Register with the event handles.
  void registerWith(event::ChannelManager& m) {}

private:
  typedef std::map<std::string, long> OperatorMap;
  typedef OperatorMap::const_iterator OperatorMapIterator;

  OperatorMap operatorCounter_;
  OperatorMap laOperatorCounter_;
  OperatorMap heuOoperatorCounter_;
};

}

#endif
