/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef RDTSC_TIMER_H_INCLUDED
#define RDTSC_TIMER_H_INCLUDED
#include <string>
#if defined(_MSC_VER) || defined(__WATCOMC__)
typedef unsigned __int64 uint64;
#else
typedef unsigned long long uint64;
#endif

// returns the current value of the rdtsc
extern "C" uint64 readTimeStampCounter();

// Params:
// mTime: measuring time (i.e. time in milli seconds between two measuring points)
// iterations: number of consecutive measurements
// Return:
// The approximate CPU-Speed in Mhz (average of the individual measurements)
extern "C" unsigned long measureCpuSpeed(unsigned mTime, unsigned iterations);

// measures five times each time with a duration of 500 milli seconds.
// Return:
// The approximate CPU-Speed in Mhz (average of the individual measurements)
inline unsigned long measureCpuSpeed() {
  return measureCpuSpeed(500, 5);
}

// Timer that uses the processor's time stamp counter.
class TscTimer {
public:
  void start() {
    startTicks_ = readTimeStampCounter();
  }
  void stop() {
    endTicks_ = readTimeStampCounter();
  }
  void reset();
  uint64 result() const;

  // PRE: setCpuSpeed or measureCpuSpeed was called
  std::string resultAsTimeString() const;

  static void setCpuSpeed(unsigned speedInMhz);

  // sets the Cpu Speed to the return value of measureCpuSpeed
  static void measureCpuSpeed(unsigned mTime = 500, unsigned iterations = 5);
private:
  static unsigned long cpuSpeed_s;
  uint64 startTicks_;
  uint64 endTicks_;
};

#endif

