/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <stack.h>
#include <graph.h>

namespace NS_NOMORE {

BacktrackStack::BacktrackStack() {}


void BacktrackStack::restore(Graph& g) {
  assert(!isEmpty());
  for (Item i = stack_.top(); !i.cp_; i = stack_.top() ) {
    stack_.pop();
    g.restore(*i.node_, i.color_);
  }
}


BacktrackStack::Item BacktrackStack::restoreAndPop(Graph& g) {
  restore(g);
  Item cp = stack_.top();
  assert(cp.cp_);
  stack_.pop();
  g.restore(*cp.node_, Color::none);
  return cp;
}

}
