/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <operators/sequence.h>
#include <cassert>
namespace NS_NOMORE {

namespace {
  typedef std::vector<std::pair<Operator*,bool> > Ops;
  std::string makeName(const Ops& ops, bool closure) {
    std::string r = "(";
    for (Ops::size_type i = 0; i != ops.size(); ++i) {
      r += ops[i].first->getName();
      if (i < ops.size() - 1)
        r += ',';
    }
    r += closure ? ")*" : ")";
    return r;
  }
}

Sequence::Sequence(bool closure)
  : Operator()
	, closure_(closure) 
  , name_(makeName(Operators(), closure)) {
}

Sequence::Sequence(Operator* o1, Operator* o2, bool closure)
  : Operator()
	, closure_(closure)
  , name_() {
  add(o1);
  add(o2);
  name_ = makeName(ops_, closure);
}


Sequence::~Sequence() {
  for (Operators::size_type i = 0; i != ops_.size(); ++i)
    if (ops_[i].second)
      delete ops_[i].first;
}

ColorOpResult Sequence::operator()() {
	ColorOpResult currentRun;
  ColorOpResult result = ColorOperation::unchanged;
  do {
    currentRun = ColorOperation::unchanged;
    for (Operators::size_type i = 0; i != ops_.size(); ++i) {
      ColorOpResult op = (*ops_[i].first)();
      if (op == ColorOperation::succeeded) {
        currentRun = result = op;
      }
      else if (op == ColorOperation::failed) {
        return op;
      }
    }
  } while (closure_ && currentRun == ColorOperation::succeeded);
  return result;
}

void Sequence::setClosure(bool b) {
	closure_ = b;
  
  if (closure_ && *name_.rbegin() != '*') {
    name_ += '*';
  }
  else if (!closure_ && *name_.rbegin() == '*') {
    name_.erase(name_.size() - 1);
  }
}

void Sequence::add(Operator* o) {
  assert(o);
  ops_.push_back(OpInfo(o, true));
  name_ = makeName(ops_, closure_);
}

void Sequence::add(Operator& o) {
  ops_.push_back(OpInfo(&o, false));
  name_ = makeName(ops_, closure_);
}

void Sequence::add(Operator* o, bool takeOverOwnership) {
  if (takeOverOwnership)
    add(o);
  else
    add(*o);
}

Operator* Sequence::extractOperator(const std::string& name) {
  for (Operators::size_type i = 0; i != ops_.size(); ++i) {
    if (Operator* op = ops_[i].first->extractOperator(name))
      return op;
  }
  return 0;
}

bool Sequence::validate(const OpSet& ops) const {
  for (Operators::size_type i = 0; i != ops_.size(); ++i) {
    if (!ops_[i].first->validate(ops))
      return false;
  }
  return true;
}

void Sequence::reset() {
  for (Operators::size_type i = 0; i != ops_.size(); ++i) {
    ops_[i].first->reset();
  }
}

const char* Sequence::getName() const {
  return name_.c_str();
}


}
