/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <statistics/mode_watcher.h>
#include <event/channel_manager.h>
#include <operators/lookahead.h>
#include <heuristic.h>

namespace NS_NOMORE {

ModeWatcher::ModeWatcher(event::ChannelManager& m) : StatisticsObject() {
  registerWith(m);
  StatisticsObject::setCurrentMode(Mode::normal);
}

ModeWatcher::~ModeWatcher() {
}

void ModeWatcher::registerWith(event::ChannelManager& m) {
  m.getChannelFor(event::Event<LookaheadExecution>()).connect(*this);
  m.getChannelFor(event::Event<HeuristicExecution>()).connect(*this);
}

void ModeWatcher::handle(const LookaheadExecution& e) {
  if(e.state_ == ActivityState::started)
    StatisticsObject::setCurrentMode(Mode::lookahead);
  else if(e.state_ == ActivityState::finished)
    StatisticsObject::setCurrentMode(Mode::normal);
}

void ModeWatcher::handle(const HeuristicExecution& e) {
  if(e.state_ == ActivityState::started)
    StatisticsObject::setCurrentMode(Mode::heuristic);
  else if(e.state_ == ActivityState::finished)
    StatisticsObject::setCurrentMode(Mode::normal);
}

}
