/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_COLOR_H
#define LIBNOMORE_COLOR_H

namespace NS_NOMORE {

//! Defines the possible color values of a node.
struct Color {

  //! Color values.
  enum ColorValue {
    //! Uncolored.
    none      =  1,
    //! Minus. Node is not in the answer set.
    minus     =  2,
    //! Plus. Node is in the answer set.
    plus      =  4,
    //! Weak plus. Node must be in the answer set but currently there is no proof.
    weak_plus =  8,
  };

  //! Color states.
  enum {
    //! A node is colored if the color of the node is minus, plus or ignore.
    colored = minus | plus,
    //! A node is uncolored if the color of the node is none or weak_plus.
    uncolored = none | weak_plus
  };

  //! returns true iff v is either minus, plus or ignore.
  static bool isColored(ColorValue v) {
     return (v & colored) != 0;
  }

  //! returns true iff v is either none or weak_plus.
  static bool isUncolored(ColorValue v) {
    return (v & uncolored) != 0;
  }
};

//! Defines the possible results of a color operation.
struct ColorOperation {
  enum Value {
    failed,     /*< the operation failed, i.e. produced an invalid coloring */
    succeeded,  /*< the operation succeeded, one ore more nodes changed their color */
    unchanged   /*< the operation successed, but no color changes were made. */
  };
};

typedef ColorOperation::Value ColorOpResult;

}

#endif
