/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_NEIGHBORHOOD_HEURISTIC_H
#define LIBNOMORE_NEIGHBORHOOD_HEURISTIC_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <heuristic.h>
#include <utility>
#include <operators/forward_prop.h>
#include <operators/backward_prop.h>

namespace NS_NOMORE {

class Operator;

class Neighborhood : public Heuristic {
public:
    //! the type of the heuristic value
  typedef std::pair<int, int> ValueType;
  
  //! creates a new object
  explicit Neighborhood(int maxDepth = 3);
    
  ~Neighborhood();
    
  

  void setPropagationOperator(Operator& op);

  void setMaxDepth(int m);
  
  

  bool propagate(Node* n, Constraint::Type t);

  void handle(const HeadNodeColored&);
  void handle(const BodyNodeColored&);

  const char* getName() const;

private:
  void doSetGraph();
  Choice doSelectNode(const Constraint& c);
  typedef std::pair<ForwardPropagator::BodyQueue, ForwardPropagator::HeadQueue> PQueue;
  typedef std::pair<BackwardPropagator::BodyQueue, BackwardPropagator::HeadQueue> BQueue;
  bool propagateNewColor(Node* n);
  void evaluate(Node* n, ValueType vt);
  void registerEventHandlers();
  void unregisterEventHandlers();
  Choice getBestChoice(Constraint::Type t) const;
  
  std::pair<ForwardPropagator*, bool> p_;
  std::pair<BackwardPropagator*, bool> b_;  
  int max_;
  
///////////////////////////////////////////////////////////////////////////////
// Logically the queues don't need to be members. Local variables would do it, too.
// Using members  has the advantage that the underlying std::deques can reuse
// the memory between calls to this heuristic.
  PQueue savePQueue_;
  PQueue runPQueue_;
  BQueue saveBQueue_;
  BQueue runBQueue_;
///////////////////////////////////////////////////////////////////////////////
  int currentValue_;
  bool lastStep_;
  std::pair<Node*, ValueType> bestNode_;
  
  
};


}
#endif
